package com.huigou.topsun.sap.permit.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: LXH
 * @Date: 2024/03/26/10:45
 * @Description:放行条
 */
@Table(name = "sap_permit")
@Entity
@Data
public class SapPermit extends FlowBillAbstractEntity {
    /**
     * 公司
     */
    @Column(name = "company")
    private String company;

    /**
     * 责任部门
     */
    @Column(name = "duty_depart")
    private String dutyDepart;

    @Column(name = "duty_depart_name")
    private String dutyDepartName;


    /**
     * 申请人
     */
    @Column(name = "apply_person")
    private String applyPerson;

    @Column(name = "apply_person_name")
    private String applyPersonName;
    /**
     * 携出人
     */
    @Column(name = "belong_person")
    private String belongPerson;

    /**
     * 日期
     */
    @Column(name = "permit_date")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date permitDate;

    /**
     * 车牌号
     */
    @Column(name = "car_no")
    private String carNo;

    /**
     * 是否空车
     */
    @Column(name = "is_empty_car")
    private String isEmptyCar;

    @Override
    protected String getCodeRuleId() {
        return "sapPermit";
    }
}
