package com.huigou.topsun.sap.nonProducePick.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.nonProducePick.application.NonProducePickApplication;
import com.huigou.topsun.sap.nonProducePick.application.NonProducePickItemApplication;
import com.huigou.topsun.sap.nonProducePick.domain.NonProducePick;
import com.huigou.topsun.sap.nonProducePick.domain.NonProducePickItem;
import com.huigou.topsun.sap.nonProducePick.domain.query.NonProducePickQueryRequest;
import com.huigou.topsun.sap.nonProducePick.repository.NonProducePickItemRepository;
import com.huigou.topsun.sap.nonProducePick.repository.NonProducePickRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/13/9:45
 * @Description:
 */
@Service("nonProducePickItemApplication")
public class NonProducePickItemApplicationImpl extends BaseApplication implements NonProducePickItemApplication {
    @Autowired
    private NonProducePickItemRepository nonProducePickItemRepository;
    @Autowired
    private NonProducePickRepository nonProducePickRepository;
    @Autowired
    private NonProducePickApplication nonProducePickApplication;
    @Override
    public void saveNonProducePickItems(String nonProducePickId, List<NonProducePickItem> nonProducePickItems) {
        for (NonProducePickItem nonProducePickItem : nonProducePickItems) {
            nonProducePickItem.setNonProducePickId(nonProducePickId);
            nonProducePickItemRepository.save(nonProducePickItem);
        }
    }

    @Override
    public Map<String, Object> queryNonProducePickItems(NonProducePickQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getNonProducePickId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "nonProducePickItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids,String nonProducePickId) {
        NonProducePick nonProducePick = nonProducePickRepository.findOne(nonProducePickId);
        ids.forEach(id->{
            if (StringUtil.isNotBlank(nonProducePick.getMessage())){
                nonProducePickApplication.sendNonProducePickData(nonProducePick,"N");
            }
            nonProducePickItemRepository.delete(id);
        });
    }

    @Override
    public List<NonProducePickItem> findByNonProducePickId(String nonProducePickId) {
        return nonProducePickItemRepository.findByNonProducePickId(nonProducePickId);
    }

    @Override
    public NonProducePickItem findById(String id) {
        return nonProducePickItemRepository.findOne(id);
    }

    @Override
    public void updateNonProducePickItem(NonProducePickItem nonProducePickItem) {
        nonProducePickItem.setBackDate(new Date());
        nonProducePickItemRepository.save(nonProducePickItem);
    }
}
