package com.huigou.topsun.sap.inventoryRecord.controller;

import com.huigou.topsun.common.BillStatus;
import com.huigou.topsun.sap.inventoryRecord.application.InventoryRecordApplication;
import com.huigou.topsun.sap.inventoryRecord.application.InventoryRecordItemImApplication;
import com.huigou.topsun.sap.inventoryRecord.application.InventoryRecordItemWmApplication;
import com.huigou.topsun.sap.inventoryRecord.domain.InventoryRecord;
import com.huigou.topsun.sap.inventoryRecord.domain.query.InventoryRecordQueryRequest;
import com.huigou.topsun.sap.inventoryRecord.domain.vo.InventoryRecordVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.JSONUtil;
import com.huigou.util.SDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xin.lu
 * @Description: TODO
 * @date 2025/7/1711:50
 */
@Controller
@ControllerMapping("/inventoryRecord")
public class InventoryRecordController extends CommonController {
    private final static Logger LOG = LoggerFactory.getLogger(InventoryRecordController.class);

    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/inventoryRecord/";
    }
    
    @Autowired
    private InventoryRecordApplication inventoryRecordApplication;
    @Autowired
    private InventoryRecordItemWmApplication inventoryRecordItemWmApplication;
    @Autowired
    private InventoryRecordItemImApplication inventoryRecordItemImApplication;

    @SkipAuth
    @RequestMapping( value = "/getInventoryRecord")
    @ResponseBody
    private HashMap<String, Object> getInventoryRecord(@RequestBody List<InventoryRecordVo> inventoryRecordVos){
        HashMap<String, Object> messageMap = new HashMap<>();
        messageMap.put("CODE","S");
        messageMap.put("MSG","成功");
        LOG.info("库存盘点数据=={}", JSONUtil.toString(inventoryRecordVos));
        try {
            if (ObjectUtils.isEmpty(inventoryRecordVos)){
                messageMap.put("CODE","E");
                messageMap.put("MSG","未接收到数据，请检查");
                messageMap.put("DATA","");
            }else {
                List<Map<String,Object>> mapList = this.inventoryRecordApplication.saveInventoryRecordVo(inventoryRecordVos);
                String string = JSONUtil.toString(mapList);
                messageMap.put("DATA",string);
            }
        }catch (RuntimeException e){
            messageMap.put("CODE","E");
            messageMap.put("MSG",e.getMessage());
            messageMap.put("DATA","");
        }finally {
            LOG.info("库存盘点返回数据=={}", JSONUtil.toString(messageMap));
        }
        return messageMap;
    }

    public String forwardInventoryRecordWmList(){
        this.putAttribute("statusKindsList", BillStatus.getValidMap());
        this.putAttribute("loginId",this.getOperator().getPersonMemberId());
        return forward("wm/inventoryRecordWmList");
    }

    public String forwardInventoryRecordImList(){
        this.putAttribute("statusKindsList", BillStatus.getValidMap());
        this.putAttribute("loginId",this.getOperator().getPersonMemberId());
        return forward("im/inventoryRecordImList");
    }

    public String slicedInventoryRecordWmList(){
        SDO sdo = this.getSDO();
        InventoryRecordQueryRequest queryRequest = sdo.toQueryRequest(InventoryRecordQueryRequest.class);
        Map<String, Object> map = inventoryRecordApplication.slicedInventoryRecordWmList(queryRequest);
        return toResult(map);
    }

    public String queryInventoryRecordWmByInventoryRecordId(){
        SDO sdo = this.getSDO();
        String inventoryRecordId = sdo.getString("inventoryRecordId");
        return packGridDataAndResult(inventoryRecordItemWmApplication.queryInventoryRecordItemWms(inventoryRecordId));
    }

    public String slicedInventoryRecordImList(){
        SDO sdo = this.getSDO();
        InventoryRecordQueryRequest queryRequest = sdo.toQueryRequest(InventoryRecordQueryRequest.class);
        Map<String, Object> map = inventoryRecordApplication.slicedInventoryRecordImList(queryRequest);
        return toResult(map);
    }

    public String queryInventoryRecordImByInventoryRecordId(){
        SDO sdo = this.getSDO();
        String inventoryRecordId = sdo.getString("inventoryRecordId");
        return packGridDataAndResult(inventoryRecordItemImApplication.queryInventoryRecordItemIms(inventoryRecordId));
    }

    public String showInventoryRecordDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        InventoryRecord inventoryRecord = inventoryRecordApplication.loadInventoryRecord(id);
        switch (inventoryRecord.getZtype()){
            case "IM":
                return forward("im/inventoryRecordImDetail",inventoryRecord);
            case "WM":
                return forward("wm/inventoryRecordWmDetail",inventoryRecord);
        }
        return null;
    }
}
