package com.huigou.topsun.sap.inventoryRecord.application.impl;

import cn.hutool.core.bean.BeanUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.inventoryRecord.application.InventoryRecordItemImApplication;
import com.huigou.topsun.sap.inventoryRecord.domain.InventoryRecordItemIm;
import com.huigou.topsun.sap.inventoryRecord.domain.query.InventoryRecordQueryRequest;
import com.huigou.topsun.sap.inventoryRecord.domain.vo.InventoryRecordVo;
import com.huigou.topsun.sap.inventoryRecord.repository.InventoryRecordItemImRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xin.lu
 * @Description: TODO
 * @date 2025/7/1710:38
 */
@Service("inventoryRecordItemImApplication")
public class InventoryRecordItemImApplicationImpl extends BaseApplication implements InventoryRecordItemImApplication {
    @Autowired
    private InventoryRecordItemImRepository inventoryRecordItemImRepository;

    @Override
    public void saveInventoryRecordItemIms(String inventoryRecordId, List<InventoryRecordItemIm> inventoryRecordItemIms) {
        inventoryRecordItemIms.forEach(inventoryRecordItemIm -> {
            inventoryRecordItemIm.setInventoryRecordId(inventoryRecordId);
            inventoryRecordItemImRepository.save(inventoryRecordItemIm);
        });
    }

    @Override
    public Map<String, Object> queryInventoryRecordItemIms(InventoryRecordQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getInventoryRecordId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "inventoryRecordItemIms");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public List<InventoryRecordItemIm> queryInventoryRecordItemIms(String inventoryRecordId) {
            return inventoryRecordItemImRepository.findByInventoryRecordId(inventoryRecordId);
    }

    @Override
    public void saveInventoryRecordImVo(List<InventoryRecordVo> inventoryRecordVos, String inventoryRecordId) {
        List<InventoryRecordItemIm> inventoryRecordItemIms = new ArrayList<>();
        for (InventoryRecordVo inventoryRecordVo : inventoryRecordVos) {
            InventoryRecordItemIm inventoryRecordItemIm = new InventoryRecordItemIm();
            BeanUtil.copyProperties(inventoryRecordVo, inventoryRecordItemIm);
            inventoryRecordItemIm.setInventoryRecordId(inventoryRecordId);
            inventoryRecordItemIms.add(inventoryRecordItemIm);
        }
        inventoryRecordItemImRepository.save(inventoryRecordItemIms);
    }
}
