package com.huigou.topsun.sap.fixedAssets.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssetsMoveApplication;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedRetirementApplication;
import com.huigou.topsun.sap.fixedAssets.domain.SapFixedAssetsMove;
import com.huigou.topsun.sap.fixedAssets.domain.SapRetirement;
import com.huigou.topsun.sap.fixedAssets.domain.TmpFixedRetirementData;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedAssetsMoveQueryRequest;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedRetirementQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.tool.dataimport.application.ExcelImportApplication;
import com.huigou.util.CommonUtil;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/03/08/15:34
 * @Description:
 */
@Controller
@ControllerMapping("/sapFixedRetirement")
public class SapFixedRetirementController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/fixedAssets/sapFixedRetirement/";
    }

    @Resource
    private SapFixedRetirementApplication sapFixedRetirementApplication;


    private ExcelImportApplication excelImportApplication;

    public String forwardSapFixedRetirementList(){
        return forward("sapFixedRetirementList");
    }

    public String slicedSapFixedRetirementList(){
        SDO sdo = this.getSDO();
        SapFixedRetirementQueryRequest queryRequest = sdo.toQueryRequest(SapFixedRetirementQueryRequest.class);
        Map<String, Object> map = sapFixedRetirementApplication.getFixedRetirementList(queryRequest);
        return toResult(map);
    }

    public String forwardSapFixedRetirementDetail(){
        this.putAttribute("processDefinitionKey", SapFixedRetirementApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SapRetirement sapRetirement = new SapRetirement();
        sapRetirement.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        sapRetirement.setAttbizId(CommonUtil.createGUID()); // 自动生成附件id
        Operator operator = getOperator();
        sapRetirement.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
       // ExcelImportTemplate excelImportTemplate=excelImportApplication.loadExcelImportTemplateByCode("sapFixedRetirementData");
        return forward("sapFixedRetirementDetail",sapRetirement);
    }

    public String showFixedRetirement(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
       // this.putAttribute("attbizId", id); // 设置附件id
        SapRetirement sapRetirement = sapFixedRetirementApplication.getFixedRetirementById(id);
       // sapRetirement.setAttbizId(id);
        return forward("sapFixedRetirementDetail",sapRetirement);
    }

    /**
     * 删除固定资产报废
     */
    public String deleteSapFixedRetirement() {
        List<String> ids = this.getSDO().getIds();
        sapFixedRetirementApplication.deleteByIds(ids);
        return success();
    }
    /*
     *导入数据
    */
    public String importExcelData() {
        SDO sdo = this.getSDO();
        String batchNumber = sdo.getString("batchNumber");
        List<TmpFixedRetirementData> dataList= sapFixedRetirementApplication.importExcelData(batchNumber);
        return toResult(dataList);
    }
}
