package com.huigou.topsun.sap.fixedAssets.controller;

import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssessItemApplication;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedAssessQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/03/13/10:12
 * @Description:
 */
@Controller
@ControllerMapping("/sapFixedAssessItem")
public class SapFixedAssessItemController extends CommonController {
    @Autowired
    private SapFixedAssessItemApplication sapFixedAssessItemApplication;

    public String querySapFixedAssessItems(){
        SDO sdo = this.getSDO();
        SapFixedAssessQueryRequest queryRequest = sdo.toQueryRequest(SapFixedAssessQueryRequest.class);
        Map<String, Object> map = sapFixedAssessItemApplication.querySapFixedAssessItems(queryRequest);
        return toResult(map);
    }

    public String deleteSapFixedAssessItems(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        sapFixedAssessItemApplication.deleteByIds(ids);
        return success();
    }
}
