package com.huigou.topsun.sap.fixedAssets.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.topsun.sap.fixedAssets.domain.TmpFixedAssessData;
import com.huigou.topsun.sap.fixedAssets.domain.TmpFixedRetirementData;
import com.huigou.topsun.sap.fixedAssets.repository.TmpFixedRetirementDataRepository;
import com.huigou.uasp.bmp.configuration.application.DictionaryApplication;
import com.huigou.uasp.tool.dataimport.application.ExcelImportInterface;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
@Service("sapFixedRetirementExcelImport")
public class SapFixedRetirementExcelImport implements ExcelImportInterface {


    @Autowired
    private TmpFixedRetirementDataRepository tmpFixedRetirementDataRepository;
    @Override
    public void executeImport(String batchNumber) {
        List<TmpFixedRetirementData> tmpFixedRetirementDataList = tmpFixedRetirementDataRepository.findByBatchNumber(batchNumber);
        if (!CollectionUtils.isEmpty(tmpFixedRetirementDataList)){
            for (TmpFixedRetirementData tmpFixedRetirementData : tmpFixedRetirementDataList) {
                if (StringUtil.isNotBlank(tmpFixedRetirementData.getProzs()) && StringUtil.isNotBlank(tmpFixedRetirementData.getAnbtr())){
                    throw new RuntimeException("金额和百分比不能同时有值");
                }

                if (StringUtil.isBlank(tmpFixedRetirementData.getXa())){
                    throw new RuntimeException("购置业务年度不能为空");
                }else {
                    String xa = DictUtil.getDictionaryDetailValue("sapFixedRetirementYear", tmpFixedRetirementData.getXa());
                    if (StringUtil.isBlank(xa)){
                        throw new RuntimeException("未找到购置业务年度“"+tmpFixedRetirementData.getXa()+"” 对应的字典编码");
                    }
                }
            }
        }
    }

}
