package com.huigou.topsun.sap.fixedAssets.application.impl;

import com.huigou.topsun.sap.fixedAssets.domain.SapFixedAssets;
import com.huigou.topsun.sap.fixedAssets.domain.TmpFixedAssetsData;
import com.huigou.topsun.sap.fixedAssets.repository.SapFixedAssetsRepository;
import com.huigou.topsun.sap.fixedAssets.repository.TmpFixedAssetsDataRepository;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.tool.dataimport.application.ExcelImportInterface;
import com.huigou.util.ClassHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

@Service("sapFixedAssetsExcelImport")
public class SapFixedAssetsExcelImport implements ExcelImportInterface {


    @Autowired
    private TmpFixedAssetsDataRepository tmpFixedAssetsDataRepository;
    @Autowired
    private SapFixedAssetsRepository sapFixedAssetsRepository;
    @Override
    public void executeImport(String batchNumer) {
        List<TmpFixedAssetsData> tmpFixedAssetsData = tmpFixedAssetsDataRepository.findByBatchNumber(batchNumer);
        if (!CollectionUtils.isEmpty(tmpFixedAssetsData)){
            List<SapFixedAssets> sapFixedAssetsList = new ArrayList<>();
            for (TmpFixedAssetsData tmpFixedAssetsDatum : tmpFixedAssetsData) {
                SapFixedAssets sapFixedAssets = new SapFixedAssets();
                ClassHelper.copyProperties(tmpFixedAssetsDatum,sapFixedAssets);
                sapFixedAssets.setDefaultValues();
                sapFixedAssets.setZfiflg(1);
                sapFixedAssets.setType("S");
                sapFixedAssets.setMessage("创建成功");
                sapFixedAssets.setZfibpmnr(sapFixedAssets.getBillCode());
                sapFixedAssets.setStatusId(BizBillStatus.COMPLETED.getId());
                sapFixedAssetsList.add(sapFixedAssets);
            }
            sapFixedAssetsRepository.save(sapFixedAssetsList);
        }
        System.out.println("=========================");
    }

}
