package com.huigou.topsun.sap.fixedAssets.application.impl;

import com.huigou.topsun.sap.fixedAssets.domain.TmpFixedAssessData;
import com.huigou.topsun.sap.fixedAssets.domain.TmpFixedRetirementData;
import com.huigou.topsun.sap.fixedAssets.repository.TmpFixedAssessDataRepository;
import com.huigou.topsun.sap.fixedAssets.repository.TmpFixedRetirementDataRepository;
import com.huigou.uasp.tool.dataimport.application.ExcelImportInterface;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service("sapFixedAssessExcelImport")
public class SapFixedAssessExcelImport implements ExcelImportInterface {


    @Autowired
    private TmpFixedAssessDataRepository tmpFixedAssessDataRepository;
    @Override
    public void executeImport(String batchNumer) {
        List<TmpFixedAssessData> tmpFixedAssessList = tmpFixedAssessDataRepository.findByBatchNumber(batchNumer);
        if (!CollectionUtils.isEmpty(tmpFixedAssessList)){
            for (TmpFixedAssessData tmpFixedAssessData : tmpFixedAssessList) {
                if (StringUtil.isNotBlank(tmpFixedAssessData.getProzs()) && StringUtil.isNotBlank(tmpFixedAssessData.getBetrr())){
                    throw new RuntimeException("金额和百分比不能同时有值");
                }
            }
        }
        System.out.println("=========================");
      //  orgSyncApplication.sync(SyncKind.PSM, portalPeoples);
    }

}
