package com.huigou.topsun.sap.dull.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * SAP呆滞物料明细
 *
 * @TableName sap_dull_item
 */
@Table(name = "sap_dull_item")
@Entity
@Data
public class SapDullItem extends AbstractEntity {
    /**
     * SAP呆滞物料id
     */
    @Column(name = "sap_dull_id")
    private String sapDullId;

    /*
     * 物料
     *  */
    @Column(name = "matnr")
    private String  matnr;


    @Column(name = "matnr_name")
    private String  matnrName;

    /**
     * 批次
     */
    @Column(name = "batch")
    private String batch;


    //天数
    @Column(name = "dull_days")
    private Integer dullDays;

    /**
     * 数量
     */
    @Column(name = "quantity")
    private BigDecimal quantity;

    /**
     * 库存地点
     */
    @Column(name = "store")
    private String  store;
    /**
     * 库存地点名称
     */
    @Column(name = "store_name")
    private String  storeName;

    /**
     * 说明
     */
    @Column(name = "remark")
    private String remark;


}