package com.huigou.topsun.sap.dull.controller;

import com.huigou.topsun.sap.componentSupply.application.ComponentSupplyItemApplication;
import com.huigou.topsun.sap.componentSupply.domain.query.ComponentSupplyQueryRequest;
import com.huigou.topsun.sap.dull.application.SapDullItemApplication;
import com.huigou.topsun.sap.dull.domain.query.SapDullQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date:  2024/07/03 10:10
 * @Description:
 */
@Controller
@ControllerMapping("/sapDullItem")
public class SapDullItemController extends CommonController {
    @Autowired
    private SapDullItemApplication sapDullItemApplication;

    public String querySapDullItems(){
        SDO sdo = this.getSDO();
        SapDullQueryRequest queryRequest = sdo.toQueryRequest(SapDullQueryRequest.class);
        Map<String, Object> map = sapDullItemApplication.querySapDullItems(queryRequest);
        return toResult(map);
    }

    public String deleteSapDullItems(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        sapDullItemApplication.deleteByIds(ids);
        return success();
    }
}
