package com.huigou.topsun.sap.customerDelayPay.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/04/13/11:40
 * @Description: 客户延期付款申请
 */
@Table(name = "sap_customer_delay_pay")
@Entity
@Data
public class CustomerDelayPay extends FlowBillAbstractEntity {
    /**
     * 公司代码
     */
    @Column(name = "BUKRS")
    private String bukrs;

    /**
     * 公司代码描述
     */
    @Column(name = "BUKRS_NAME")
    private String bukrsName;

    /**
     * 客户编码
     */
    @Column(name = "CUSTOMER")
    private String customer;

    /**
     * 客户编码描述
     */
    @Column(name = "NAME")
    private String name;

    /**
     * 扣单应收项次
     * （勾选传输X，不勾选留空）
     */
    @Column(name = "XBLOCK")
    private String xblock;

    /**
     * 客户承诺付款时间
     */
    @Column(name = "PAY_DATE")
    private Date payDate;

    @Column(name = "TYPE")
    private String type;

    @Column(name = "MESSAGE")
    private String message;
    @Override
    protected String getCodeRuleId() {
        return "customerDelayPay";
    }
}
