package com.huigou.topsun.sap.componentSupply.controller;

import com.huigou.topsun.sap.componentSupply.application.ComponentSupplyItemApplication;
import com.huigou.topsun.sap.componentSupply.domain.query.ComponentSupplyQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date:  2024/06/03 10:10
 * @Description:
 */
@Controller
@ControllerMapping("/componentSupplyItem")
public class ComponentSupplyItemController extends CommonController {
    @Autowired
    private ComponentSupplyItemApplication componentSupplyItemApplication;

    public String queryComponentSupplyItems(){
        SDO sdo = this.getSDO();
        ComponentSupplyQueryRequest queryRequest = sdo.toQueryRequest(ComponentSupplyQueryRequest.class);
        Map<String, Object> map = componentSupplyItemApplication.queryComponentSupplyItems(queryRequest);
        return toResult(map);
    }

    public String deleteComponentSupplyItems(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        componentSupplyItemApplication.deleteByIds(ids);
        return success();
    }
}
