package com.huigou.topsun.sap.componentSupply.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.componentSupply.application.ComponentSupplyApplication;
import com.huigou.topsun.sap.componentSupply.application.ComponentSupplyItemApplication;
import com.huigou.topsun.sap.componentSupply.domain.ComponentSupply;
import com.huigou.topsun.sap.componentSupply.domain.query.ComponentSupplyQueryRequest;
import com.huigou.topsun.sap.permit.application.SapPermitApplication;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.tool.dataimport.application.ExcelImportApplication;
import com.huigou.util.CommonUtil;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**组件补充协议
 * @Auther: LXH
 * @Date: 2024/06/03 10:10
 * @Description:
 */
@Controller
@ControllerMapping("/componentSupply")
public class ComponentSupplyController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/componentSupply/";
    }

    @Resource
    private ComponentSupplyApplication componentSupplyApplication;
    @Autowired
    private ComponentSupplyItemApplication componentSupplyItemApplication;

   // private ExcelImportApplication excelImportApplication;

    public String forwardComponentSupplyList(){
        return forward("componentSupplyList");
    }

    public String slicedComponentSupplyList(){
        SDO sdo = this.getSDO();
        ComponentSupplyQueryRequest queryRequest = sdo.toQueryRequest(ComponentSupplyQueryRequest.class);
        Map<String, Object> map = componentSupplyApplication.getComponentSupplyList(queryRequest);
        return toResult(map);
    }

    public String forwardComponentSupplyDetail(){
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("processDefinitionKey", componentSupplyApplication.PROCESS_DEFINITION_KEY);
        this.putAttribute("procUnitId", "Apply");
        ComponentSupply componentSupply = new ComponentSupply();
        componentSupply.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        componentSupply.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        componentSupply.setAttbizId(CommonUtil.createGUID()); // 自动生成附件id
       // ExcelImportTemplate excelImportTemplate=excelImportApplication.loadExcelImportTemplateByCode("ComponentSupplyData");
        return forward("componentSupplyDetail",componentSupply);
    }

    public String showComponentSupply(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
       // this.putAttribute("attbizId", id); // 设置附件id
        ComponentSupply componentSupply = componentSupplyApplication.getComponentSupplyById(id);
       // sapRetirement.setAttbizId(id);
        return forward("componentSupplyDetail",componentSupply);
    }

    /**
     * 删除组件补充发料
     */
    public String deleteComponentSupply() {
        List<String> ids = this.getSDO().getIds();
        componentSupplyApplication.deleteByIds(ids);
        return success();
    }


}
