package com.huigou.topsun.sap.common.controller;

import com.huigou.topsun.sap.common.application.SapMutualEpLogApplication;
import com.huigou.topsun.sap.common.domain.SapMutualEpLog;
import com.huigou.topsun.sap.common.domain.query.MutualEpLogQueryRequest;
import com.huigou.topsun.sap.common.repository.SapMutualEpLogRepository;
import com.huigou.topsun.sap.costCenter.domain.query.CostCenterQueryRequest;
import com.huigou.topsun.sap.nonProdApply.domain.query.NonProdApplyBaseInfoQueryRequest;
import com.huigou.topsun.sap.suppliers.domain.SuppliersInfo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.Map;

/**
 * @Auther: lxh
 * @Date: 2024/1、04/16/11:36
 * @Description:
 */
@Controller
@ControllerMapping("/mutualEpLog")
public class MutualEpLogController extends CommonController {

    @Autowired
    private SapMutualEpLogApplication sapMutualEpLogApplication;

    @Autowired
    SapMutualEpLogRepository sapMutualEpLogRepository;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/mutualEpLog/";
    }


    /**
     * 跳转到传输日志查询列表
     *
     * @return
     */
    public String forwardMutualEpLogList() {
        return forward("mutualEpLogList");
    }

    public String slicedMutualEpLogList() {
        SDO sdo = this.getSDO();
        MutualEpLogQueryRequest queryRequest = sdo.toQueryRequest(MutualEpLogQueryRequest.class);

        Map<String, Object> map = sapMutualEpLogApplication.slicedMutualEpLogQuery(queryRequest);
        return toResult(map);
    }

    public String showMutualEpLog() {
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
       // String isDetailPage = sdo.getString("isDetailPage");

      //  if("true".equals(isDetailPage)) this.putAttribute("isDetailPage","true");
        SapMutualEpLog sapMutualEpLog = sapMutualEpLogRepository.findOne(id);
        return forward("mutualEpLogDetail", sapMutualEpLog);
    }
}
