package com.huigou.topsun.sap.clientMaterials.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: LXH
 * @Date: 2024/06/05/10:45
 * @Description:客户供料通知
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Table(name = "sap_client_materials")
@Entity
@Data
public class ClientMaterials extends AbstractEntity {
    /**
     * 工厂
     */
    @Column(name = "werks")
    private String werks;

    /**
     * 客供料
     */
    @Column(name = "matnr")
    private String matnr;

    /**
     * 客供料名称
     */
    @Column(name = "maktx")
    private String maktx;

    /**
     * 期初日期
     */
    @Column(name = "pertr")
    private String pertr;

    /**
     * 订单开始日期
     */
    @Column(name = "psttr")
    private String psttr;

    /**
     * 订单完成日期
     */
    @Column(name = "pedtr")
    private String pedtr;

    /**
     * 订货数量
     */
    @Column(name = "gsmng")
    private BigDecimal gsmng;

    /**
     * 单位
     */
    @Column(name = "meins")
    private String meins;

    /**
     * 计划订单
     */
    @Column(name = "plnum")
    private String plnum;

    /**
     * 销售订单
     */
    @Column(name = "kdauf")
    private String kdauf;

    /**
     * 行项次
     */
    @Column(name = "kdpos")
    private String kdpos;

    /**
     * 生产订单
     */
    @Column(name = "aufnr")
    private String aufnr;

    /**
     * 已关单
     */
    @Column(name = "closed")
    private String closed;

    /**
     * 跟单员名称
     */
    @Column(name = "person_member_name")
    private String personMemberName;

    /**
     * 跟单员ID
     */
    @Column(name = "person_member_id")
    private String personMemberId;

    /**
     * 全路径
     */
    @Column(name = "full_id")
    private String fullId;

    @Column(name = "delete_time")
    private Date deleteTime;

    /**
     * 删除人员ID
     */
    @Column(name = "delete_person_member_id")
    private String deletePersonMemberId;

    /**
     * 删除人员名称
     */
    @Column(name = "delete_person_member_name")
    private String deletePersonMemberName;

    /**
     * 客户名称
     */
    @Column(name = "kunnr_name")
    private String kunnrName;

}
