package com.huigou.topsun.sap.cashSettlementUnPay.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@Table(name = "sap_cash_settlement_unPay_item_detail")
@Entity
@Data
public class CashSettlementUnPayItemDetail extends AbstractEntity {
    /**
     * itemId
     */
    @Column(name = "cash_settlement_unPay_item_id")
    private String cashSettlementUnPayItemId;

    /**
     * 项次
     */
    @Column(name = "detail_no")
    private String detailNo;

    /**
     * 销售单号
     */
    @Column(name = "sale_no")
    private String saleNo;

    /**
     * 销售项次
     */
    @Column(name = "sale_detail_no")
    private String saleDetailNo;

    /**
     * 订单类型
     */
    @Column(name = "order_type")
    private String orderType;

    /**
     * 验收日期
     */
    @Column(name = "accept_date")
    private Date acceptDate;

    /**
     * 验收单号
     */
    @Column(name = "accept_no")
    private String acceptNo;

    /**
     * 审核销售订单日
     */
    @Column(name = "audit_date")
    private Date auditDate;

    /**
     * 客户单号
     */
    @Column(name = "custom_no")
    private String customNo;

    /**
     * 产品类别
     */
    @Column(name = "product_category")
    private String productCategory;

    /**
     * 产品编码
     */
    @Column(name = "product_code")
    private String productCode;

    /**
     * 产品名称
     */
    @Column(name = "product_name")
    private String productName;

    /**
     * 指令号
     */
    @Column(name = "order_no")
    private String orderNo;

    /**
     * 型体配色
     */
    @Column(name = "color")
    private String color;

    /**
     * 单位（客户）
     */
    @Column(name = "custom_unit")
    private String customUnit;

    /**
     * 请款量
     */
    @Column(name = "apply_num")
    private BigDecimal applyNum;

    /**
     * 单价
     */
    @Column(name = "price")
    private BigDecimal price;

    /**
     * 是否客户确认单价
     */
    @Column(name = "customer_confirm")
    private String customerConfirm;

    /**
     * 单重
     */
    @Column(name = "one_price")
    private BigDecimal onePrice;

    /**
     * 实际金额
     */
    @Column(name = "real_amount")
    private BigDecimal realAmount;

    /**
     * 应收金额
     */
    @Column(name = "receivable_amount")
    private BigDecimal receivableAmount;

    /**
     * 请款重量
     */
    @Column(name = "apply_weight")
    private BigDecimal applyWeight;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 单价折扣%
     */
    @Column(name = "price_discount")
    private BigDecimal priceDiscount;

    /**
     * 单价折后金额
     */
    @Column(name = "price_discount_amount")
    private BigDecimal priceDiscountAmount;

    /**
     * 是否扣款%
     */
    @Column(name = "is_deduction")
    private String isDeduction;

    /**
     * 是否增款%
     */
    @Column(name = "is_add")
    private String isAdd;

    /**
     * 产品编码（客户）
     */
    @Column(name = "customer_product_code")
    private String customerProductCode;

    /**
     * 产品名称（客户）
     */
    @Column(name = "customer_product_name")
    private String customerProductName;

    /**
     * 跟单员
     */
    @Column(name = "salesman")
    private String salesman;

    /**
     * 预收单号
     */
    @Column(name = "advance_receipt_no")
    private String  advanceReceiptNo;

}