package com.huigou.topsun.sap.cashSettlementUnPay.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: LX
 * @Date: 2025/06/268/10:45
 * @Description: 现结未付款先发货
 */
@Table(name = "sap_cash_settlement_unPay")
@Entity
@Data
public class CashSettlementUnPay extends FlowBillAbstractEntity {
    /**
     * 客户编码
     */
    @Column(name = "customer_code")
    private String customerCode;

    /**
     * 客户名称
     */
    @Column(name = "customer_name")
    private String customerName;

    /**
     * 金额
     */
    @Column(name = "amount")
    private BigDecimal amount;

    /**
     * 理由
     */
    @Column(name = "reason")
    private String reason;

    /**
     * 修改人
     */
    @Column(name = "update_person_id")
    private String updatePersonId;

    @Column(name = "update_person_name")
    private String updatePersonName;

    /**
     * 修改日期
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 收款状态
     */
    @Column(name = "pay_status")
    private String payStatus;

    @Override
    protected String getCodeRuleId() {
            return "cashSettlementUnPay";
    }
}
