package com.huigou.topsun.mes.unqualifiedMaterials.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Auther: xin.lu
 * @Date: 2024/08/12/10:25
 * @Description: 质量异常评审表
 */
@Entity
@Data
@Table(name = "mes_unqualified_materials")
public class UnqualifiedMaterials extends FlowBillAbstractEntity {

    /**
     * 物料凭证号
     */
    @Column(name = "MBLNR")
    private String mblnr;

    /**
     * 凭证项次
     */
    @Column(name = "ZEILE")
    private String zeile;

    /**
     * 凭证年份
     */
    @Column(name = "MJAHR")
    private String mjahr;
    
    /**
     * 产品名称
     */
    @Column(name = "product_name")
    private String productName;

    /**
     * 类别
     */
    @Column(name = "type")
    private String type;

    /**
     * 生产批次
     */
    @Column(name = "batch_no")
    private String batchNo;

    /**
     * PD/YL编码
     */
    @Column(name = "pd")
    private String pd;

    /**
     * 部门/工序
     */
    @Column(name = "process")
    private String process;

    /**
     * 异常数量
     */
    @Column(name = "exception_num")
    private BigDecimal exceptionNum;

    /**
     * 异常描述
     */
    @Column(name = "exception_desc")
    private String exceptionDesc;

    /**
     * 责任部门
     */
    @Column(name = "duty_dept")
    private String dutyDept;

    /**
     * 责任部门
     */
    @Column(name = "duty_dept_name")
    private String dutyDeptName;

    /**
     * 提报人
     */
    @Column(name = "submitter")
    private String submitter;

    /**
     * 提报人
     */
    @Column(name = "submitter_name")
    private String submitterName;

    /**
     * 默认处理结果（来自上一个节点）
     */
    @Column(name = "default_result")
    private String defaultResult;

    /**
     * 处理结果
     */
    @Column(name = "result")
    private String result;

    /**
     * 是否裁决 1是，0否
     */
    @Column(name = "has_decide")
    private String hasDecide;

    /**
     * MES返回状态码
     */
    @Column(name = "code")
    private String code;

    /**
     * MES返回消息
     */
    @Column(name = "msg")
    private String msg;

    /**
     * 采购单号
     */
    @Column(name = "purchase_order_no")
    private String purchaseOrderNo;

    /**
     * 仓管员
     */
    @Column(name = "usnam")
    private String usnam;

    /**
     * sap订单类型
     */
    @Column(name = "order_type")
    private String orderType;

    /**
     * 订单数量
     */
    @Column(name = "quantity")
    private String quantity;

    /**
     * 供应商名称
     */
    @Column(name = "vendor_name")
    private String vendorName;

    /**
     * 供应商编码
     */
    @Column(name = "vendor_code")
    private String vendorCode;
    @Override
    protected String getCodeRuleId() {
        return "unqualifiedMaterials";
    }
}
