package com.huigou.topsun.mes.produceException.domain.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Auther: xin.lu
 * @Date: 2024/08/12/10:25
 * @Description: 质量异常评审表
 */
@Data
public class ProduceExceptionVo implements Serializable {
    /**
     * 异常单号
     */
    @JsonProperty("exceptionNo")
    private String exceptionNo;

    /**
     * 编排单号
     */
    @JsonProperty("layoutNo")
    private String layoutNo;

    /**
     * 工序名称
     */
    @JsonProperty("process")
    private String process;

    /**
     * 工作中心名称
     */
    @JsonProperty("workerCenter")
    private String workerCenter;

    /**
     * 作业单元名称
     */
    @JsonProperty("workerUnit")
    private String workerUnit;

    /**
     * 物料号
     */
    @JsonProperty("materialNo")
    private String materialNo;

    /**
     * 物料名称
     */
    @JsonProperty("materialName")
    private String materialName;

    /**
     * 异常类型
     */
    @JsonProperty("exceptionType")
    private String exceptionType;

    /**
     * 异常原因
     */
    @JsonProperty("exceptionReason")
    private String exceptionReason;

    /**
     * 异常描述
     */
    @JsonProperty("exceptionDesc")
    private String exceptionDesc;

    /**
     * 异常时间
     */
    @JsonProperty("exceptionDate")
    private String exceptionDate;

    /**
     * 提交人
     */
    @JsonProperty("submitter")
    private String submitter;

    /**
     * 提交人
     */
    @JsonProperty("submitterName")
    private String submitterName;

    /**
     * 审批人编码
     */
    @JsonProperty("approvalCode")
    private String approvalCode;

    /**
     * 审批人名称
     */
    @JsonProperty("approvalName")
    private String approvalName;
}
