package com.huigou.topsun.ep.order.domain.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/12/17:21
 * @Description: EP销售订单明细
 */
@Data
public class EpSaleOrderCancelItemVo implements Serializable {
    /**
     * EP销售订单id
     */
    private String epSaleOrderId;

    /**
     * 销售单号
     */
    @JsonProperty("vbeln")
    private String vbeln;

    /**
     * 销售凭证项目
     */
    @JsonProperty("posnr")
    private String posnr;

    /**
     * 物料编号
     */
    @JsonProperty("matnr")
    private String matnr;

    /**
     * 物料描述
     */
    @JsonProperty("maktx")
    private String maktx;

    /**
     * 订单数量
     */
    @JsonProperty("kwmeng")
    private BigDecimal kwmeng;

    /**
     * 销售单位
     */
    @JsonProperty("vrkme")
    private String vrkme;

    /**
     * 生产单号
     */
    @JsonProperty("produceCode")
    private String produceCode;

    /**
     * 工序
     */
    @JsonProperty("process")
    private String process;

    /**
     * 单价
     */
    @JsonProperty("price")
    private BigDecimal price;

    /**
     * 跟单员
     */
    @JsonProperty("merchandiser")
    private String merchandiser;

}
