package com.huigou.topsun.ep.order.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.ep.order.application.EpSaleOrderCancelItemApplication;
import com.huigou.topsun.ep.order.domain.EpSaleOrderCancelItem;
import com.huigou.topsun.ep.order.domain.query.EpSaleOrderCancelQueryRequest;
import com.huigou.topsun.ep.order.repository.EpSaleOrderCancelItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/12/19:20
 * @Description:
 */
@Service("epSaleOrderCancelItemApplication")
public class EpSaleOrderCancelItemApplicationImpl extends BaseApplication implements EpSaleOrderCancelItemApplication {
    @Autowired
    private EpSaleOrderCancelItemRepository epSaleOrderCancelItemRepository;
    @Override
    public void saveEpSaleOrderCancelItems(String epSaleOrderCancelId, List<EpSaleOrderCancelItem> epSaleOrderCancelItems) {
        epSaleOrderCancelItems.forEach(epSaleOrderCancelItem -> {
            epSaleOrderCancelItem.setEpSaleOrderCancelId(epSaleOrderCancelId);
            String s = epSaleOrderCancelItem.getMatnr().replaceAll("^(0+)", "");
            epSaleOrderCancelItem.setMatnr(s);
            epSaleOrderCancelItemRepository.save(epSaleOrderCancelItem);
        });
    }

    @Override
    public Map<String, Object> queryEpSaleOrderCancelItems(EpSaleOrderCancelQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getEpSaleOrderCancelId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "epSaleOrderCancelItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            epSaleOrderCancelItemRepository.delete(id);
        });
    }

    @Override
    public List<EpSaleOrderCancelItem> findByEpSaleOrderCancelId(String epSaleOrderCancelId) {
        return epSaleOrderCancelItemRepository.findByEpSaleOrderCancelId(epSaleOrderCancelId);
    }
}
