package com.huigou.topsun.ep.change.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.ep.change.application.EpChangeFormImplItemApplication;
import com.huigou.topsun.ep.change.domain.EpChangeFormImplItem;
import com.huigou.topsun.ep.change.domain.query.EpChangeFormQueryRequest;
import com.huigou.topsun.ep.change.repository.EpChangeFormImplItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/06/19/11:48
 * @Description:
 */
@Service("epChangeFormImplItemApplication")
public class EpChangeFormImplItemApplicationImpl extends BaseApplication implements EpChangeFormImplItemApplication {
    @Autowired
    private EpChangeFormImplItemRepository changeFormImplItemRepository;
    @Override
    public Map<String,Object> findByEpChangeFormId(EpChangeFormQueryRequest queryRequest) {
        Map<String,Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getEpChangeFormId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "epChangeFormImplItem");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            queryModel.putDictionary("confirm", DictUtil.getDictionary("confirm"));
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void saveEpChangeFormImplItems(String epChangeFormId, List<EpChangeFormImplItem> items) {
        for (EpChangeFormImplItem item : items) {
            item.setEpChangeFormId(epChangeFormId);
        }
        changeFormImplItemRepository.save(items);
    }

    @Override
    public void deleteItems(List<String> ids) {
        for (String id : ids) {
            changeFormImplItemRepository.delete(id);
        }
    }

    @Override
    public Map<String, Object> findByOldId(EpChangeFormQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "epChangeFormItemByOldId");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        queryModel.putDictionary("confirm", DictUtil.getDictionary("confirm"));
        return this.sqlExecutorDao.executeSlicedQuery(queryModel);
    }
}
