package com.huigou.topsun.controller;

import com.huigou.cache.SystemCache;
import com.huigou.topsun.sap.permit.application.SapPermitApplication;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.bmp.doc.attachment.application.AttachmentApplication;
import com.huigou.uasp.bmp.doc.attachment.domain.model.Attachment;

import com.huigou.uasp.client.CommonController;
import com.huigou.util.ApplicationContextWrapper;
import com.huigou.util.SDO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

@ControllerMapping("/PDFViewer")
@Controller
public class PDFViewerController extends CommonController {

    @Override
    public String getPagePath() {
        return "/pdfjs/";
    }

    @SkipAuth
    public String displayPDF() {
         SDO sdo = this.getSDO();
         String id = sdo.getString("id");
         String applicationType = sdo.getString("applicationType");
        try {
            ByteArrayOutputStream byteArrayOutputStream=null;
            Object object=ApplicationContextWrapper.getBean(applicationType+"Application");
            Method method =  object.getClass().getMethod("printInfo", HttpServletResponse.class, String.class);
            byteArrayOutputStream =(ByteArrayOutputStream)method.invoke(object, this.getResponse(), id);

            InputStream in=new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
             HttpServletResponse response=this.getResponse();
             ServletOutputStream out = response.getOutputStream();
             IOUtils.copy(in, out);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }



    public String PDFViewer() {
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        String applicationType = sdo.getString("applicationType");

        putAttribute("id", id);
        putAttribute("fileId", id);
        putAttribute("applicationType", applicationType);
        return forward("PDFViewer"); // 跳转预览pdf页面
    }
}