package com.huigou.topsun.common;

import com.huigou.context.OrgUnit;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.uasp.annotation.Expression;
import com.huigou.uasp.bmp.fn.AbstractDaoFunction;
import com.huigou.uasp.bmp.fn.impl.OrgFun;
import com.huigou.uasp.bmp.opm.proxy.OrgApplicationProxy;
import com.huigou.uasp.bmp.opm.repository.org.OrgRepository;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 硬X射线使用函数
 *
 * @author xiexin
 */
@Expression
@Service("function")
public class Function extends AbstractDaoFunction {

	@Autowired
	private OrgFun orgFun;

	@Autowired
	protected OrgApplicationProxy orgApplication;

	@Autowired
	private OrgRepository orgRepository;


	private String getSqlByname(String sqlName) {
		QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery("config/topsun/base/function.xml",
				"function");
		return queryDescriptor.getSqlByName(sqlName);
	}

	/**
	 * 根据基础管理权限查询对应的数据管理权限
	 * 
	 * @param cs
	 * @return
	 */
	public List<String> queryBizManagementTypeByCode(List<String> cs) {
		Assert.notEmpty(cs);
		String sql = this.getSqlByname("queryBizManagementTypeByCode");
		StringBuffer sb = new StringBuffer();
		sb.append(sql);
		sb.append(" and t.code in (");
		int l = cs.size();
		for (int i = 0; i < l; i++) {
			sb.append("'").append(cs.get(i)).append("'");
			if (i < l - 1) {
				sb.append(",");
			}
		}
		sb.append(")");
		return this.sqlExecutorDao.queryToList(sb.toString(), String.class);
	}

	/**
	 * 根据业务主表id和业务表名查询对应申请人的直接领导
	 * @param bizId
	 * @param tableName
	 * @return
	 */
	public List<OrgUnit> findbmjl(String bizId,String tableName){
		Assert.hasText(bizId, "参数id不能为空。");
		String sql = this.getSqlByname("querybmjl");
		sql = sql.replace("%s",tableName);
		return this.sqlExecutorDao.queryToList(sql, OrgUnit.class,bizId);
	}

	/**
	 * 根据业务主表id和业务表名查询销售跟单员的直接领导
	 * @param bizId
	 * @return
	 */
	public List<OrgUnit> querySalebmjl(String bizId){
		Assert.hasText(bizId, "参数id不能为空。");
		String sql = this.getSqlByname("querySalebmjl");
		return this.sqlExecutorDao.queryToList(sql, OrgUnit.class,bizId);
	}

	/**
	 * 根据业务主表id和业务表名查询对应申请人的二级部门领导
	 * @param bizId
	 * @param tableName
	 * @return
	 */
	public List<OrgUnit> findejbmjl(String bizId,String tableName){
		Assert.hasText(bizId, "参数id不能为空。");
		String sql = this.getSqlByname("queryejbmld");
		sql = sql.replace("%s",tableName);
		return this.sqlExecutorDao.queryToList(sql, OrgUnit.class,bizId);
	}

	/**
	 * 根据业务主表id和业务表名查询对应申请人的一级部门领导
	 * @param bizId
	 * @param tableName
	 * @return
	 */
	public List<OrgUnit> findyjbmjl(String bizId,String tableName){
		Assert.hasText(bizId, "参数id不能为空。");
		String sql = this.getSqlByname("queryyjbmld");
		sql = sql.replace("%s",tableName);
		return this.sqlExecutorDao.queryToList(sql, OrgUnit.class,bizId);
	}

	/**
	 * 根据业务主表id查询申请人
	 * @param bizId
	 * @return
	 */
	public List<OrgUnit> findPersonMember(String bizId){
		Assert.hasText(bizId, "参数id不能为空。");
		String sql = this.getSqlByname("findPersonMember");
		return this.sqlExecutorDao.queryToList(sql, OrgUnit.class,bizId);
	}

	public List<OrgUnit>  findResponsible(String bizId){
		String sql = this.getSqlByname("findResponsibleException");
		//sql = sql.replace("%s",tableName);
		List<OrgUnit>  orgUnits=this.sqlExecutorDao.queryToList(sql, OrgUnit.class,bizId);
		if  (StringUtil.isBlank(orgUnits.get(0).getFullId())){
			sql = this.getSqlByname("findDepartException");
			orgUnits=this.sqlExecutorDao.queryToList(sql, OrgUnit.class,bizId);
		}
		return orgUnits;
	}

	/**
	 * 根据业务主表id查询审批人
	 * @param bizId
	 * @return
	 */
	public List<OrgUnit> fundApproval(String bizId){
		Assert.hasText(bizId, "参数id不能为空。");
		String sql = this.getSqlByname("fundApproval");
		return this.sqlExecutorDao.queryToList(sql, OrgUnit.class,bizId);
	}

	/**
	 * 根据业务id查询指定的执行人
	 * @param bizId
	 * @return
	 */
	public List<OrgUnit> fundECNApproval(String bizId){
		Assert.hasText(bizId, "参数id不能为空。");
		String sql = this.getSqlByname("fundECNItemApproval");
		String sqlStock = this.getSqlByname("fundECNStockItemApproval");
		List<OrgUnit> orgUnits = this.sqlExecutorDao.queryToList(sql, OrgUnit.class, bizId);
		List<OrgUnit> orgUnitStocks = this.sqlExecutorDao.queryToList(sqlStock, OrgUnit.class, bizId);
		orgUnits.addAll(orgUnitStocks);
		HashSet<OrgUnit> orgUnitHashSet = new HashSet<>(orgUnits);
		ArrayList<OrgUnit> orgUnitArrayList = new ArrayList<>(orgUnitHashSet);
		return orgUnitArrayList;
	}

	/**
	 * 根据业务主表id查询申请人
	 * @param bizId
	 * @return
	 */
	public List<OrgUnit> findPurchaseOrderPersonMember(String bizId){
		Assert.hasText(bizId, "参数id不能为空。");
		String sql = this.getSqlByname("findPurchaseOrderPersonMember");
		return this.sqlExecutorDao.queryToList(sql, OrgUnit.class,bizId);
	}
}
