package com.huigou.topsun.base.bsnMessage.domain;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 任务启动/任务发布实体
 * @TableName bsn_message_sponsor
 */
@Table(name="bsn_message_sponsor")
@Entity
@Data
public class BsnMessageSponsor implements Serializable {
    /**
     * 
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    private String id;

    /**
     * 任务标题
     */
    private String title;

    /**
     * 任务发起人
     */
    @Column(name = "task_sponsor")
    private String taskSponsor;

    /**
     * 业务表单id
     */
    @Column(name = "business_id")
    private String businessId;

    /**
     * 创建日期
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 完成日期
     */
    @Column(name = "finished_date")
    private Date finishedDate;

    /**
     * 任务执行地址
     */
    @Column(name = "executor_url")
    private String executorUrl;

    /**
     * 完成状态（等待：0，审核：1,结束：2）
     */
    private Integer status;


    @Transient
    private List<BsnMessageExecute> executes;

    public void addExecute(BsnMessageExecute execute){
        if(this.executes==null){
            this.executes = new ArrayList<>();
        }
        executes.add(execute);
    }

    private static final long serialVersionUID = 1L;

}