var detailGridManager = null, refreshFlag = false;
$(document).ready(function () {
        initUI();
        initGrid();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function initGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({

    });

    detailGridManager = UICtrl.grid('#aufnrgrid', {
            columns: [
                {
                    display: "工单号", name: "AUFNR", width: "100", align: "left", type: "string",
                },
                {
                    display: "产品类别", name: "MTART", width: "100", align: "left", type: "string",
                },
                {
                    display: "产品类别描述", name: "MTBEZ", width: "100", align: "left", type: "string",
                },
                {
                    display: "产品编码", name: "PLNBEZ", width: "300", align: "left", type: "string",
                    render:function(item){
                        return item.PLNBEZ.replace(/^0+/, '');
                    }
                },
                {
                    display: "产品名称", name: "MAKTX", width: "300", align: "left", type: "string",
                },
                // {
                //     display: "工序编号", name: "VORNR", width: "50", align: "left", type: "string",
                // },
                // {
                //     display: "工序描述", name: "LTXA1", width: "200", align: "left", type: "string",
                // },
                {
                    display: "工单数量", name: "GAMNG", width: "100", align: "left", type: "string",
                },
                {
                    display: "LOSS数", name: "ZLOSSC", width: "100", align: "left", type: "string",
                },
                {
                    display: "单位编码", name: "MSEH3", width: "100", align: "left", type: "string",
                },
                {
                    display: "单位描述", name: "MSEHL", width: "100", align: "left", type: "string",
                },

            ],
            dataAction: 'server',
            url: web_app.name + '/processOutsource/queryAufnrFromMes.ajax?',
            parms: {},
            toolbar: toolbarOptions,
            width: '99.8%',
            height: 400,
            pageSize: 20,
            heightDiff: -4,
            sortName: 'num',
            sortOrder: 'asc',
            checkbox: true,
            usePager: false,
            rownumbers: true,
            enabledEdit: true,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            enableObjectBag: true,
        }
    );
    UICtrl.setSearchAreaToggle(detailGridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(detailGridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

