var gridManager = null;
var refreshFlag = false;

$(document).ready(function () {
    initializateUI()
    loadProcessOutsourceOrderListGrid();
    bindEvent();
})
function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}
function loadProcessOutsourceOrderListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function (){
            addHandler()
        },
    });
    gridManager = UICtrl.grid("#processOutsourceOrderGrid", {
        columns: [
            {display: "申请单编号", name: "billCode", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请状态", name: "statusTextView", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "申请日期", name: "fillinDate", width: 120, minWidth: 60, type: "datetime", align: "left"},
            {display: "需求日期", name: "bedat", width: 140, minWidth: 60, type: "date", align: "left"},
            {display: "工厂", name: "werksName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "采购订单", name: "ebeln", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "订单行项目号", name: "ebelp", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "序号", name: "sequence", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "原工单", name: "aufnr", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "产品类别", name: "productTypeName", width: 140, minWidth: 60, type: "string", align: "left",},
            {display: "产品编码", name: "productCode", width: 140, minWidth: 60, type: "string", align: "left",},
            {display: "产品名称", name: "productName", width: 200, minWidth: 60, type: "string", align: "left",},
            {display: "工序号", name: "wempf", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "工序描述", name: "txz01", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "补数工单", name: "ablad", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "单价", name: "kbetr", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "数量", name: "menge", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "单位", name: "meinsName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "定价基数", name: "kpein", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "币别", name: "waersTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "税码", name: "purchaseMwskzTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "交货日期", name: "eeind", width: 140, minWidth: 60, type: "date", align: "left"},
            {display: "供应商", name: "lifnrName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},

        ],
        dataAction: "server",
        _tableKey: 'processOutsource',
        _local: true,
        url: web_app.name + '/processOutsource/slicedProcessOutsourceList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        sortName:"fillinDate",
        sortOrder: 'desc',
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        async: false,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.processOutsourceId);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function bindEvent(){
    $("#deptName").orgTree({
        filter: "dpt", excludePos: 0, param: {orgKindId: "ogn,dpt",orgRoot: '14636F3F48934EE7811768692A0AC5E1'},
        back: {
            text: "#deptName",
            value : '#deptName'
        },
    });

    $("#personMemberName").orgTree({
        filter: "psm", excludePos: 0, param: {orgKindId: "ogn,dpt,pos,psm",orgRoot: '14636F3F48934EE7811768692A0AC5E1'},
        back: {
            text: "#personMemberName",
            value : '#personMemberId'
        },
    });

    //产品类别
    $('#productTypeName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "MATKL"}
        },
        onChange: function (value, data) {
            $('#productType').val(data.MATKL);
            $('#productTypeName').val(data.WGBEZ);
        }
    });
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'processOutsourceApply',
        text: "临时工序外协申请",
        url: web_app.name + '/processOutsource/forwardProcessOutsourceDetail.job'
    });
}

function doView(processOutsourceId) {
    UICtrl.addTabItem({
        tabid: 'processOutsource'+processOutsourceId,
        text: "临时工序外协申请明细",
        url: web_app.name + '/processOutsource/showProcessOutsourceDetail.job?isReadOnly=true&bizId='+processOutsourceId
    });
}

