var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();

}


function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
        deleteHandler: deleteHandler
       // exportExcelHandler:exportExcelHandler,
       // exportModelHandler:{id:'exportModelHandler',img:'fa-cloud-download',text:'导出模板',click:exportModelHandler},

    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "单据编号", name: "billCode", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请状态", name: "statusTextView", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "公司", name: "company", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "放行日期", name: "permitDate", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "携出人", name: "belongPerson", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "责任部门", name: "dutyDepartName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "applyPersonName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "创建人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "创建部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/sapPermit/slicedSapPermitList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}


//删除按钮
function deleteHandler() {
    let result=DataUtil.getUpdateRow(gridManager);
    if(result.status!==0){
        Public.tip("请选择申请状态的数据！")
        return false;
    }

 //   var message = "您确认要删除选择的数据?";
   // UICtrl.confirm(message, function () {
        DataUtil.del({
            action: 'sapPermit/deleteSapPermit.ajax',
            gridManager: gridManager, idFieldName: 'id',
            onSuccess: function () {
                reloadGrid();
            }
        });
   // });

}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'addSapPermit',
        text: "新增放行条",
        url: web_app.name + '/sapPermit/forwardSapPermitDetail.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'viewSapPermit'+id,
        text: "放行条",
        url: web_app.name + '/sapPermit/showPermit.job?bizId='+id+"&isReadOnly=true"
    });
}


