var gridManager = null;

$(document).ready(function () {
    initialize();
    loadGrid();
    bindEvent();
});
function initialize(){
    //if (typeof(getSubProcUnitId) =='function'&&"10" === getSubProcUnitId()) {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function bindEvent(){
    $("#dutyDepartName").orgTree({
        filter: "dpt", excludePos: 0, param: {orgKindId: "ogn,dpt"},
        back: {
            text: "#dutyDepartName",
            value : '#dutyDepart'
        },
        //manageType: 'taskQuery',
        onChange:function(value,data){
            $('#dutyDepart').val(data.id);
        }
    });

    $("#applyPersonName").orgTree({
        filter: "psm", excludePos: 0, param: {orgKindId: "ogn,dpt,pos,psm"},
        back: {
            text: "#applyPersonName",
            value : '#applyPerson'
        },
        //manageType: 'taskQuery',
        onChange:function(value,data){
            $('#applyPerson').val(data.id);
        }
    });
}

function loadGrid() {
    var toolbarOptions =null;
    //if ($("#statusId").val()==0){
       toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            UICtrl.addGridRow(gridManager);
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#maingrid');
            DataUtil.delSelectedRows({
                action: 'sapPermitItem/deleteSapPermitItems.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'id',
                onSuccess: function () {
                    reloadGrid();
                }
            });
        },
        copyHandler: copyHandler
       // impExcelDataHandler:{id:'impExcelData',img:'fa-table',text:'导入数据',click:impExcelDataHandler},

     });
  //  }
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {
                display: "采购单号", name: "ebeln", width: "160", align: "left", type: "string",
                editor: {
                    required: false, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {fieldName: "EKPO"}
                        },
                        back: {
                            EBELN: "ebeln",
                            MATNR: "matnr",
                            TXZ01: "belongings",
                            ZNAME: "lifnrName",
                            MEINS: "unit",
                            MSEHL: "unitName"
                        }
                    }
                }
            },
            {
                display: "携出物品编码", name: "matnr", width: "160", align: "left", type: "string",
            },
            { display: "携出物品名称", name: "belongings", width: 380, minWidth: 200, type: "string", align: "left",
              editor: {  type: "text",required: true   }
            },

            { display: "数量", name: "quantity", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {  type: "text",mask: 'nnnnnn.nn',required: true }
            },
            {display: "unit", name: "unit", width: "140", align: "left", type: "string", hide: true},
            { display: "单位", name: "unitName", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "dictionary",
                        getParam: function (item) {
                            return {fieldName: "MEINS"}
                        },
                        back: {
                            MSEH3: "unit",
                            MSEHL: "unitName",
                        }
                    }
                }
            },
            {
                display: "备注", name: "remark", width: 480, minWidth: 60, type: "string", align: "left",
                editor: {required: false, type: "text"}
            }

        ],
        dataAction: "server",
        url: web_app.name + '/sapPermitItem/querySapPermitItems.ajax',
        pageSize: 10,
        usePager: true,
        parms:{sapPermitId:getId()},
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "80%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onAfterEdit:function (item) {
            if (item.column.name == "ebeln" ){
                var lifnrName = item.record.lifnrName;
                $("#company").val(lifnrName);
            }
            //如果是空车，不用胡总审核
            if (item.column.name == "belongings" ){
                if (item.value.indexOf("空车") > -1 ){
                    $("#isEmptyCar").val("Y");
                }else {
                    $("#isEmptyCar").val("0");
                }
            }
            return item;
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);

    var _grid=UICtrl.getGridManager('#maingrid');
    _grid.options.parms.sapPermitId = id;
    $('#sapRetirementInfoList').fileList({
        bizId : id
    });
}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    return $("#id").val() || "";
}

function reloadGrid() {
    gridManager.loadData();
}

function  printPage() {
    Public.openPostWindow(web_app.name + '/sapPermit/printInfo.load',{id: $("#id").val()});
}

function getExtendedData(processAction) {
//回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
//不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });

        if (!datas) {
            return false;
        }
        extendedData.items = Public.encodeJSONURI(datas);
    }
    return extendedData;
}

//复制新增
function copyHandler() {
   // var g = this;
     var rows = gridManager.getSelectedRows();
    if (rows.length == 0) {
        Public.tip('请选择数据!');
        return;
    }
    for (var i = 0; i < rows.length; i++){
        var row=rows[i];
       gridManager.addRows({
           belongings: row.belongings,
           unitName: row.unitName,
           unit: row.unit,
           quantity: row.quantity,
           remark: row.remark
       });
   }
}