<%@ page language="java" contentType="text/html; charset=utf-8" %>
<%@taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,dialog,grid,tree,combox,commonTree,date,attachment"/>
    <x:script src='/biz/topsun/sap/nonOrderStorage/nonOrderStorageDetail.js'/>
</head>
<body>
<div class="container-fluid">
<x:billTitle title="无订单库存入库情况说明" needStatus="false" needPerson="true"/>
<div class="blank_div clearfix"></div>
<form class="hg-form" method="post" action="" id="submitForm">
    <x:hidden name="id"/>
    <x:hidden name="version"/>
    <x:hidden name="billCode"/>
    <x:hidden name="fillinDate" type="datetime"/>
    <x:hidden name="fullId"/>
    <x:hidden name="organId"/>
    <x:hidden name="organName"/>
    <x:hidden name="deptId"/>
    <x:hidden name="deptName"/>
    <x:hidden name="positionId"/>
    <x:hidden name="positionName"/>
    <x:hidden name="personMemberId"/>
    <x:hidden name="personMemberName"/>
    <x:hidden name="statusId"/>
    <x:hidden name="productCode"/>
    <x:hidden name="unit"/>
    <x:hidden name="werks"/>
    <x:hidden name="store"/>
    <x:hidden name="type"/>
    <x:hidden name="message"/>
    <div class="hg-form-cols">
        <div class="hg-form-row">
            <x:inputC name="werksName" required="true" label="工厂" labelCol="1" wrapper="select" fieldCol="2"/>
            <x:inputC name="productName" required="true" label="品名" labelCol="1" maxLength="64" fieldCol="2" wrapper="select"/>
            <x:inputC name="number" required="true" label="数量" labelCol="1" maxLength="64" fieldCol="2"/>
            <x:inputC name="unitName" required="true" label="单位" labelCol="1" wrapper="select" fieldCol="2"/>
        </div>
        <div class="hg-form-row">
            <x:selectC name="isCharge" required="true" label="是否收费" labelCol="1" dictionary="yesorno" fieldCol="2"/>
            <x:inputC name="storeName" required="false" label="库存地点" labelCol="1" wrapper="select" fieldCol="2"/>
            <!--x:inputC name="supplier" required="true" label="供应商" labelCol="1" fieldCol="2"/-->
            <x:hidden name="supplier"/>
            <x:inputC name="supplierName" label="供应商名称" labelCol="1" fieldCol="2" wrapper="select"/>
            <x:inputC name="amount" required="false" label="总价值" labelCol="1" fieldCol="2" mask="positiveMoney"/>
        </div>
        <div class="hg-form-row">
            <x:textareaC name="reason" required="true" label="事由" labelCol="1" rows="3" fieldCol="6"/>
        </div>
    </div>
    <div style="padding-top: 15px;">
        <x:fileList bizCode="nonOrderStorage" bizId="id" id="nonOrderStorageList" title="附件" />
    </div>
</form>
</div>
</body>
</html>
