var gridManager = null;
var refreshFlag = false;

$(document).ready(function () {
    initializateUI()
    loadMutualEpLogDataListGrid();
})
function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}
function loadMutualEpLogDataListGrid() {

    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        });
    gridManager = UICtrl.grid("#mutualEpLogDataListGrid", {
        columns: [

            {display: "创建日期", name: "createdDate", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "业务类型", name: "businessType", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "状态", name: "type", width: 80, minWidth: 60, type: "string", align: "left"},
            {display: "返回消息", name: "message", width: 400, minWidth: 60, type: "string", align: "left"},
            {display: "参数", name: "parameter", width: 460, minWidth: 60, type: "string", align: "left"},

        ],
        dataAction: "server",
        url: web_app.name + '/mutualEpLog/slicedMutualEpLogList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        async: false,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
        onAfterShowData: function (data){
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}


function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}


function doView(id) {
     var title="传输日志详情";
     UICtrl.addTabItem({
        tabid: 'mutualEpLog'+id,
        text: title,
        url: web_app.name + '/mutualEpLog/showMutualEpLog.do?id='+id
    });
}

// 关闭对话框
function onDialogCloseHandler() {
    if (refreshFlag) {
        reloadGrid();
        refreshFlag = false;
    }
}