var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadMaterialListGrid();
});


function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadMaterialListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        updateHandler: function () {
            updateHandler();
        },
        deleteHandler: deleteHandler,
        testHandler: {
            id: 'test', text: '测试接口', img: 'fa-clipboard', click: function () {
                Public.ajax(web_app.name + "/technology/testSap.ajax",{},function (data){

                })
            }
        }
    });
    gridManager = UICtrl.grid("#materialListGrid", {
        columns: [
            {display: "物料名称", name: "technologyName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "物料编码", name: "productId", width: 120, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/material/slicedMaterialList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'materialDetail',
        text: "新增物料",
        url: web_app.name + '/material/forwardAddMaterialDetail.job'
    })
}

function updateHandler(row) {
    if (!row) {
        row = DataUtil.getUpdateRow(gridManager);
        if (!row) {
            return;
        }
    }
    UICtrl.addTabItem({
        tabid: 'materialDetail' + row.id,
        text: "新增工艺",
        url: web_app.name + '/material/showMaterialDetail.job?id='+row.id
    })
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'material/deleteTechnologyByTechnologyId.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}


