var gridManager = null;
$(function () {
    initGrid();
});

function initGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
    });
        gridManager = UICtrl.grid('#grid', {
            columns: getGridColumns(),
            dataAction: 'server',
            _tableKey: 'inventoryRecordWmDetail',
            _local: true,
            url: web_app.name + '/inventoryRecord/queryInventoryRecordWmByInventoryRecordId.ajax',
            parms:{inventoryRecordId:getId()},
            height: '95%',
            heightDiff: -4,
            sortName: 'id',
            sortOrder: 'asc',
            checkbox: false,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            //autoApplyNextEditor:false,
            toolbar: toolbarOptions,
        }
    );
    UICtrl.setSearchAreaToggle(gridManager);
}

function getGridColumns() {
    var columns = [];
    columns = [
        {display: "仓库号", name: "lgnum", width: 100, minWidth: 60, type: "string", align: "center"},
        {display: "仓库描述", name: "lnumt", width: 200, minWidth: 60, type: "string", align: "center"},
        {display: "盘点记录号", name: "ivnum", width: "100", align: "left", type: "string"},
        {display: "重新盘点版本", name: "nvers", width: "100", align: "left", type: "string"},
        {display: "项目号", name: "ivpos", width: "100", align: "left", type: "string"},
        {display: "仓位", name: "lgpla", width: "100", align: "left", type: "string"},
        {display: "物料", name: "matnr", width: "100", align: "left", type: "string",
            //去掉前导0
            render: function (item) {
                return item.matnr.replace(/^0+/, "");
            }
        },
        {display: "物料描述", name: "maktx", width: "300", align: "left", type: "string"},
        {display: "批次", name: "charg", width: "100", align: "left", type: "string",},
        {display: "工厂", name: "werks", width: "100", align: "left", type: "string",},
        {display: "工厂名称", name: "name1", width: "200", align: "left", type: "string"},
        {display: "存储地点", name: "lgort", width: "100", align: "left", type: "string",},
        {display: "存储地点名称", name: "lgobe", width: "100", align: "left", type: "string",},
        {display: "库存类别", name: "bestq", width: "100", align: "left", type: "string",},
        {display: "特殊库存标识", name: "sobkz", width: "100", align: "left", type: "string",},
        {display: "特殊库存编号", name: "sonum", width: 100, minWidth: 60, type: "string", align: "center",},
        {display: "盘点数量", name: "menga", width: 100, minWidth: 60, type: "string", align: "center",},
        {display: "盘点数量单位", name: "msehl", width: 100, minWidth: 60, type: "string", align: "center",},
        {display: "账面数量", name: "gesme", width: "100", align: "left", type: "string",},
        {display: "差异（%）", name: "abwei", width: "100", align: "left", type: "string",},
        {display: "价值差额", name: "dwert", width: "100", align: "left", type: "string"},
        {display: "货币", name: "ktext", width: 100, minWidth: 60, type: "string", align: "center",},
        {display: "盘点完成日期", name: "idatu", width: 100, minWidth: 60, type: "string", align: "center",}
    ]
    return columns;
}

//获取数据保存的参数
function getExtendedData(processAction) {
    //回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
        //不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#grid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });
        if (!datas) {
            return false;
        }
        extendedData.wmItems = Public.encodeJSONURI(datas);
    }
    return extendedData;
}

function getId() {
    return $('#id').val();
}

function setId(value) {
    $("#id").val(value);
    var _grid=UICtrl.getGridManager('#grid');
    _grid.options.parms.inventoryRecordId = value;
}

function reloadGrid() {
    gridManager.loadData();
}

function getGridData(){
    var _grid = UICtrl.getGridManager('#grid');
    var datas = DataUtil.getGridData({
        gridManager: _grid,
        isAllData: true
    });
    return datas;
}


