var itemGridManager = null;
$(function () {
    initItemGrid();
});

function initItemGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
    });
        itemGridManager = UICtrl.grid('#maingrid', {
            columns: getGridColumns(),
            dataAction: 'server',
            _tableKey: 'inventoryRecordImDetail',
            _local: true,
            url: web_app.name + '/inventoryRecord/queryInventoryRecordImByInventoryRecordId.ajax',
            parms:{inventoryRecordId:getId()},
            height: '95%',
            heightDiff: -4,
            sortName: 'id',
            sortOrder: 'asc',
            checkbox: false,
            usePager: true,
            rownumbers: true,
            enabledEdit: false,
            fixedCellHeight: true,
            selectRowButtonOnly: true,
            //autoApplyNextEditor:false,
            toolbar: toolbarOptions,
        }
    );
    UICtrl.setSearchAreaToggle(itemGridManager);
}

function getGridColumns() {
    var columns = [];
    columns = [
        {display: "库存盘点凭证", name: "iblnr", width: "80", align: "left", type: "string",},
        {display: "会计年度", name: "gjahr", width: "100", align: "left", type: "string"},
        {display: "行号", name: "zeili", width: "60", align: "left", type: "string"},
        {display: "物料编号", name: "matnr", width: "100", align: "left", type: "string",
            //去掉前导零
            render: function (item) {
                return item.matnr.replace(/^0+/, "");
            }
        },
        {display: "物料描述", name: "maktx", width: "300", align: "left", type: "string"},
        {display: "工厂", name: "werks", width: "100", align: "left", type: "string",},
        {display: "工厂名称", name: "name1", width: "200", align: "left", type: "string",},
        {display: "存储地点", name: "lgort", width: "100", align: "left", type: "string"},
        {display: "存储地点名称", name: "lgobe", width: "100", align: "left", type: "string",},
        {display: "批次编号", name: "charg", width: "100", align: "left", type: "string",},
        {display: "盘点日期", name: "zldat", width: "100", align: "left", type: "string",},
        {display: "账面数量", name: "buchm", width: "100", align: "left", type: "money",},
        {display: "盘点数量", name: "erfmg", width: "100", align: "left", type: "money",},
        {display: "差额数量", name: "difmg", width: "100", minWidth: 60, type: "money", align: "center",},
        {display: "计量单位", name: "meins", width: "100", minWidth: 60, type: "string", align: "center",},
        {display: "计量单位描述", name: "msehl", width: "100", minWidth: 60, type: "string", align: "center",},
        {display: "盘点金额", name: "wrtzl", width: "100", minWidth: 60, type: "money", align: "center",},
        {display: "账面金额", name: "wrtbm", width: "100", align: "left", type: "money",},
        {display: "本币差额", name: "dmbtr", width: "100", align: "left", type: "money",},
        {display: "货币码", name: "waers", width: "100", align: "left", type: "string"},
        {display: "货币描述", name: "ktext", width: "100", minWidth: 60, type: "string", align: "center",},
    ]
    return columns;
}

//获取数据保存的参数
function getExtendedData(processAction) {
    //回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
        //不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });
        if (!datas) {
            return false;
        }
        extendedData.imItems = Public.encodeJSONURI(datas);
    }
    return extendedData;
}

function getId() {
    return $('#id').val();
}

function setId(value) {
    $("#id").val(value);
    var _grid=UICtrl.getGridManager('#maingrid');
    _grid.options.parms.inventoryRecordId = value;
}

function reloadGrid() {
    itemGridManager.loadData();
}

function getGridData(){
    var _grid = UICtrl.getGridManager('#maingrid');
    var datas = DataUtil.getGridData({
        gridManager: _grid,
        isAllData: true
    });
    return datas;
}

function doBack() {
    var data = this.iframe.contentWindow.getBackProcUnitData();
    if (!data || data.length == 0) {
        return;
    }

    var _self = this;

    var approvalParams = getApprovalParams();
    var extendedData = getExtendedData(ProcessAction.BACK);

    var params = $.extend({}, { destActivityId: data[0].taskDefKey, backToProcUnitHandlerId: data[0].procUnitHandlerId },
        approvalParams, extendedData);

    params.isBackSaveBizData = isBackSaveBizData();

    var url = web_app.name + '/workflow/back.ajax';

    $('#submitForm').ajaxSubmit({
        isCheck: params.isBackSaveBizData,
        url: url,
        param: params,
        success: function () {
            onDefaultSuccess({ dialog: _self});
        }
    });
    console.log(params.bizId);
}


