<%@ page contentType="text/html; charset=utf-8" language="java" %>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,dialog,grid,tree,dateTime,combox,attachment,commonTree,comboDialog"/>
    <x:script src="/biz/topsun/sap/exceptionReport/exceptionReportDetail.js"/>
</head>
<body>
<div class="container-fluid">
    <x:billTitle title="品质异常报告" needStatus="true" needPerson="true"/>
    <form class="hg-form" method="post" action="" id="submitForm">
        <x:hidden name="billType"/>
        <x:hidden name="id"/>
        <x:hidden name="version"/>
        <x:hidden name="attbizId"/>
        <x:hidden name="billCode"/>
        <x:hidden name="fillinDate"/>
        <x:hidden name="fullId"/>
        <x:hidden name="organId"/>
        <x:hidden name="organName"/>
        <x:hidden name="deptId"/>
        <x:hidden name="deptName"/>
        <x:hidden name="positionId"/>
        <x:hidden name="positionName"/>
        <x:hidden name="personMemberId"/>
        <x:hidden name="personMemberName"/>
        <x:hidden name="statusId"/>
        <x:hidden name="frgdt"/>
        <div class="hg-form-cols">
            <c:if test="${statusId==1||statusId==3}">
            <div style="float: right; margin-right: 10px;" class="btn-group" id="buttonBox">
                <button id="save" title="" type="button" onclick="printPage()" class="btn btn-gray"><i
                        class="fa fa-save"></i>打印
                </button>
            </div>
            </c:if>
            <div class="hg-form-row">
                <x:inputC name="werksName" required="true" label="工厂" labelCol="1" wrapper="select" fieldCol="2"/>
                <x:hidden name="werks"/>
                <x:inputC name="reportDate" label="呈报日期" labelCol="1" fieldCol="2" required="true" wrapper="date"/>
                <x:selectC name="urgency" label="紧急程度" labelCol="1" fieldCol="2" required="true" dictionary="urgency"/>
                <x:selectC name="exceptionType" label="异常类型" labelCol="1" fieldCol="2" required="true" dictionary="exceptionType"/>
                <x:selectC name="exceptionReasonType" label="原因分类" labelCol="1" fieldCol="2" required="true" dictionary="exceptionReasonType"/>
                <x:inputC name="reasonTypeDetailName" label="异常问题类型" labelCol="1" fieldCol="2" required="true" wrapper="select"/>
                <x:inputC name="reasonTypeDetail" label="异常问题类型代码" labelCol="1" fieldCol="2" readonly="true" />
                <x:inputC name="reasonTypeName" label="异常问题一级分类" labelCol="1" fieldCol="2" readonly="true"/>
                <x:inputC name="productTypeName" label="产品类别" required="false" labelCol="1" fieldCol="2" wrapper="select"/>
                <x:hidden name="productType"/>
                <!--x:inputC name="appealNo" label="客诉编号" labelCol="1" fieldCol="2" required="false"/-->
                <x:inputC name="exceptionDate" label="异常日期" labelCol="1" fieldCol="2" required="false" wrapper="date"/>
                <x:checkbox name="needImproveReport" id="needImproveReport" cssStyle="margin-left:10px;" label="客户是否需要改善报告"/>
                <x:checkbox name="needGuarantee" id="needGuarantee" cssStyle="margin-left:10px;" label="客户是否需要保证书"/>

            </div>

        </div>
        <div class="hg-form-cols" id="purchaseDiv">
            <div class="hg-form-row">

                <x:inputC name="customerNamePur" label="客户名称" labelCol="1" fieldCol="2" required="false"/>
                <x:inputC name="customerOrderNoPur" label="客户订单号" labelCol="1" fieldCol="2" required="false"/>
                <x:inputC name="brandName" label="品牌名称" labelCol="1" fieldCol="2" required="false"/>
                <x:inputC name="problemTimes" label="问题发生次数" labelCol="1" fieldCol="2" required="false"/>

                </div>
             <div id="purchasegrid"></div>
         </div>
        <div class="hg-form-cols" id="produceDiv">
            <div class="hg-form-row">
                <x:inputC name="customerNo" label="客户编号" labelCol="1" fieldCol="2" required="false" wrapper="select"/>
                <x:inputC name="customerOrderNo" label="客户单号" labelCol="1" fieldCol="2" wrapper="select" required="false"/>
                <x:inputC name="produceNo" label="生产单号" labelCol="1" fieldCol="2" wrapper="select" required="false"/>
                <x:inputC name="customerName" label="客户名称" labelCol="1" fieldCol="2" required="false" readonly="true"/>
            </div>
           <x:title title="单号信息" name="group" hideTable="#info" />
            <%--<div class="hg-form-cols" id="producegridDiv">
               <div id="producegrid"></div>
            </div>--%>
            <div class="hg-form-cols" id="clientgridDiv">
               <div id="clientgrid"></div>
            </div>
        </div>
        <div class="hg-form-row">
            <x:inputC name="payMoney" label="赔付金额" labelCol="1" fieldCol="2" required="false" />
            <x:inputC name="loseMoney" label="损失金额" labelCol="1" fieldCol="2" required="false" readonly="true" />
        </div>
        <div class="hg-form-cols">

            <div style="padding-top: 15px;">
                <x:fileList bizCode="exceptionStateInfo" bizId="attbizId" id="exceptionStateInfoList" title="相关资料" />
            </div>
            <div class="hg-form-row">
                <x:textareaC name="exceptionState" required="false" label="异常陈诉" maxLength="2500" labelCol="1" fieldCol="11" rows="3"/>
            </div>
            <div class="hg-form-row">
                <x:textareaC name="exceptionReason" required="false" label="异常原因" maxLength="1500" labelCol="1" fieldCol="11" rows="3"/>
            </div>
            <div class="hg-form-row">
                <x:textareaC name="dealMethod" required="false" label="改善措施" maxLength="1500" labelCol="1" fieldCol="11" rows="3"/>
            </div>
            <div class="hg-form-row">
                <x:inputC name="dutyDeptName" label="处理部门" labelCol="1" fieldCol="2" required="false" wrapper="tree"/>
                <x:hidden name="dutyDept"/>
                <x:inputC name="checkOperatorName" label="处理人" labelCol="1" fieldCol="2" required="false" wrapper="tree"/>
                <x:hidden name="checkOperator"/>
            </div>
            <div class="hg-form-row">
                <x:textareaC name="dealResult" required="false" label="处理结果" maxLength="1500" labelCol="1" fieldCol="11" rows="3"/>
            </div>
            <div class="hg-form-row">
                <x:inputC name="manager" label="单位主管" labelCol="1" fieldCol="2" required="false"/>
                <x:inputC name="deputyManager" label="副理" labelCol="1" fieldCol="2" required="false"/>
                <x:inputC name="generalManager" label="经理" labelCol="1" fieldCol="2" required="false"/>
            </div>
            <div class="hg-form-row">
                <x:textareaC name="remark" required="false" label="备注" maxLength="800" labelCol="1" fieldCol="11" rows="3"/>
            </div>
        </div>
        <x:title title="责任人信息" name="group" hideTable="#info" />
        <div id="dutyPersonGrid"></div>
    </form>
</div>
</body>