var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();
}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "公司代码", name: "bukrsName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "客户编码描述", name: "kunnrName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "仅显示逾期项次", name: "xblock", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "收款方式", name: "paymentMethodTextView", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "客户承诺付款时间", name: "payDate", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "状态", name: "statusTextView", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "消息文本", name: "message", width: 200, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/customerDelayPay/slicedCustomerDelayPayList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'customerDelayPay',
        text: "新增客户延期付款申请",
        url: web_app.name + '/customerDelayPay/forwardCustomerDelayPayDetail.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'customerDelayPay'+id,
        text: "查看客户延期付款申请",
        url: web_app.name + '/customerDelayPay/showCustomerDelayPayDetail.job?bizId='+id+"&isReadOnly=true"
    });
}
