var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();
}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        //addHandler: addHandler,
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "string", align: "left"},
            {
                display: "销售单号", name: "vbeln", width: 200, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "项次", name: "posnr", width: 140, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "跟单员", name: "merchandiserName", width: 100, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "物料编号", name: "matnr", width: 140, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "物料描述", name: "maktx", width: 300, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "数量", name: "kwmeng", width: 140, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "单位", name: "vrkme", width: 140, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "单价", name: "price", width: 140, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "总价", name: "amount", width: 140, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "生产单号", name: "produceCode", width: 140, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "工序", name: "process", width: 140, minWidth: 60, type: "string", align: "left",
            },
            {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "客户编码", name: "customerCode", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "客户名称", name: "customerName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "产品类型", name: "productType", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "审批状态", name: "statusTextView", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "原订单是否取消", name: "isCancelTextView", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "状态码", name: "code", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "消息", name: "msg", width: 200, minWidth: 60, type: "string", align: "left"},
        ],
        _tableKey: 'epSaleOrderCancelList',
        _local: true,
        dataAction: "server",
        url: web_app.name + '/epSaleOrderCancel/slicedEpSaleOrderCancelList.ajax',
        pageSize: 20,
        usePager: true,
        sortName: 'fillinDate',
        sortOrder: 'desc',
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'epSaleOrderCancel',
        text: "新增销售订单取消/变更",
        url: web_app.name + '/epSaleOrderCancel/forwardEpSaleOrderCancelDetail.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'epSaleOrderCancel'+id,
        text: "查看销售订单取消/变更",
        url: web_app.name + '/epSaleOrderCancel/showEpSaleOrderCancelDetail.job?bizId='+id+"&isReadOnly=true"
    });
}
