package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import lombok.Data;

/**
 * 产品版面颜色
 * @TableName product_face_color
 */
@Table(name="product_face_color")
@Entity
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProductFaceColor implements Serializable {
    /**
     * 产品颜色ID
     */
    @Id
    @Column(name = "product_face_color_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal productFaceColorId;

    /**
     * 产品版面ID
     */
    @Column(name = "product_face_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal productFaceId;

    /**
     * 颜色ID
     */
    @Column(name = "color_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal colorId;

    /**
     * 覆盖率(单位%)
     */
    @Column(name = "coverage_rate")
    private Double coverageRate;

    /**
     * 排序序号
     */
    @Column(name = "sort_order")
    private Integer sortOrder;

    public BigDecimal getProductFaceColorId() {
        return productFaceColorId;
    }

    public void setProductFaceColorId(String productFaceColorId) {
        this.productFaceColorId = (productFaceColorId != null) ? new BigDecimal(productFaceColorId) : null;
    }

    public BigDecimal getProductFaceId() {
        return productFaceId;
    }

    public void setProductFaceId(String productFaceId) {
        this.productFaceId = (productFaceId != null) ? new BigDecimal(productFaceId) : null;
    }

    public BigDecimal getColorId() {
        return colorId;
    }

    public void setColorId(String colorId) {
        this.colorId = (colorId != null) ? new BigDecimal(colorId) : null;
    }

    public Double getCoverageRate() {
        return coverageRate;
    }

    public void setCoverageRate(Double coverageRate) {
        this.coverageRate = coverageRate;
    }

    public Integer getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }
}