package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 客户基础信息
 * @TableName customer
 */
@Table(name="customer")
@Data
@Entity
public class Customer implements Serializable {
    /**
     * 客户id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 客户编码
     */
    @Column(name = "customer_code")
    private String customerCode;

    /**
     * 客户全称
     */
    @Column(name = "customer_name")
    private String customerName;

    /**
     * 客户简称
     */
    @Column(name = "customer_short_name")
    private String customerShortName;

    /**
     * 客户工作时间
     */
    @Column(name = "customer_work_time")
    private Date customerWorkTime;

    /**
     * 客户英文名称
     */
    @Column(name = "customer_en_name")
    private String customerEnName;

    /**
     * 客户英文名称简称
     */
    @Column(name = "customer_en_short_name")
    private String customerEnShortName;

    /**
     * 省份编码
     */
    @Column(name = "province_code")
    private String provinceCode;

    /**
     * 客户等级
     */
    @Column(name = "customer_level")
    private String customerLevel;

    /**
     * 工厂代号
     */
    @Column(name = "customer_factory_code")
    private String customerFactoryCode;

    /**
     * 地址
     */
    @Column(name = "customer_address")
    private String customerAddress;

    /**
     * 所属集团
     */
    @Column(name = "customer_group")
    private String customerGroup;

    /**
     * 邮编
     */
    @Column(name = "customer_zip_code")
    private String customerZipCode;

    private static final long serialVersionUID = 1L;
}