package com.huigou.topsun.sap.wasteSale.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/13/19:03
 * @Description: SAP废品销售
 */
@Data
@Entity
@Table(name = "sap_waste_sale")
public class WasteSale extends FlowBillAbstractEntity {
    /**
     * 公司代码
     */
    @Column(name = "BURKS")
    private String burks;

    /**
     * 回收商
     */
    @Column(name = "BKTXT")
    private String bktxt;

    /**
     * 回收日期
     */
    @Column(name = "BUDAT")
    private Date budat;

    /**
     * 收款方式
     */
    @Column(name = "payment_method")
    private String paymentMethod;

    /**
     * 合计
     */
    @Column(name = "total_money")
    private BigDecimal totalMoney;

    /**
     * 消息类型
     */
    @Column(name = "type")
    private String type;

    /**
     * 凭证号
     */
    @Column(name = "message_v1")
    private String messageV1;

    /**
     * 车牌号
     */
    @Column(name = "car_no")
    private String carNo;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;


    @Override
    protected String getCodeRuleId() {
        return "wasteSale";
    }
}
