package com.huigou.topsun.sap.transfers.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * SAP存货转移单
 *
 * @TableName sap_stock_transfers_item
 */
@Table(name = "sap_stock_transfers_item")
@Entity
@Data
public class SapStockTransfersItem extends AbstractEntity {
    /**
     * SAP存货转移单id
     */
    @Column(name = "transfers_id")
    private String transfersId;


    /**
     * 项目类别
     */
    @Column(name = "epstp")
    private String epstp;

    /**
     * 行项目号
     */
    @Column(name = "ebelp")
    private Integer ebelp;


    /**
     * 物料
     */
    @Column(name = "matnr")
    private String  matnr;
    //数量
    @Column(name = "menge")
    private BigDecimal menge;

    /**
     * 单位
     */
    @Column(name = "meins")
    private String meins;

    /**
     * 交货日期
     */
    @Column(name = "eeind")
    private Date eeind;
    /**
     * 库存地点
     */
    @Column(name = "lgort")
    private String lgort;

    @Column(name = "lgort_name")
    private String lgortName;

    @Column(name = "matnr_name")
    private String matnrName;

    @Column(name = "meins_name")
    private String meinsName;


    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;
}