package com.huigou.topsun.sap.transfers.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import com.topsunit.query.annotations.Dictionary;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: LXH
 * @Date: 2024/03/28/10:45
 * @Description:SAP存货转移单
 */
@Table(name = "sap_stock_transfers")
@Entity
@Data
public class SapStockTransfers extends FlowBillAbstractEntity {
    /**
     * 订单类型
     */
    @Column(name = "bsart")
    private String bsart;

    /**
     * 供货工厂
     */
    @Column(name = "lifnr")
    private String lifnr;
   /*
    *采购组织
    */
    @Column(name = "ekorg")
    private String ekorg;


    /**
     * 采购组
     */
    @Dictionary("ekgrp")
    @Column(name = "ekgrp")
    private String ekgrp;
   /*
   * 公司代码
    */
    @Column(name = "burks")
    private String burks;

    @Column(name = "burks_name")
    private String burksName;


    @Column(name = "ekgrp_name")
    private String ekgrpName;

    @Column(name = "ekorg_name")
    private String ekorgName;

    @Column(name = "lifnr_name")
    private String lifnrName;

    /**
     * 收货工厂
     */
    @Column(name = "werks")
    private String werks;

    @Column(name = "werks_name")
    private String werksName;

    @Column(name = "type")
    private String type;

    @Column(name = "message")
    private String message;

    /**
     * 采购申请号
     */
    @Column(name = "BANFN")
    private String banfn;

    @Override
    protected String getCodeRuleId() {
        return "sapStockTransfers";
    }
}
