package com.huigou.topsun.sap.transfers.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;

import com.huigou.topsun.sap.transfers.application.SapStockTransfersApplication;
import com.huigou.topsun.sap.transfers.domain.SapStockTransfers;
import com.huigou.topsun.sap.transfers.domain.query.SapStockTransfersQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.tool.dataimport.application.ExcelImportApplication;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date: 2024/03/26 10:10
 * @Description:
 */
@Controller
@ControllerMapping("/sapStockTransfers")
public class SapStockTransfersController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/transfers/";
    }

    @Resource
    private SapStockTransfersApplication sapStockTransfersApplication;


   // private ExcelImportApplication excelImportApplication;

    public String forwardSapStockTransfersList(){
        return forward("sapStockTransfersList");
    }

    public String slicedSapStockTransfersList(){
        SDO sdo = this.getSDO();
        SapStockTransfersQueryRequest queryRequest = sdo.toQueryRequest(SapStockTransfersQueryRequest.class);
        Map<String, Object> map = sapStockTransfersApplication.getStockTransfersList(queryRequest);
        return toResult(map);
    }

    public String forwardSapStockTransfersDetail(){
        this.putAttribute("processDefinitionKey", SapStockTransfersApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SapStockTransfers sapStockTransfers = new SapStockTransfers();
        sapStockTransfers.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
       // sapStockTransfers.setAttbizId(CommonUtil.createGUID()); // 自动生成附件id
        Operator operator = getOperator();
        sapStockTransfers.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
       // ExcelImportTemplate excelImportTemplate=excelImportApplication.loadExcelImportTemplateByCode("sapStockTransfersData");
        return forward("sapStockTransfersDetail",sapStockTransfers);
    }

    public String showStockTransfers(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
       // this.putAttribute("attbizId", id); // 设置附件id
        SapStockTransfers sapStockTransfers = sapStockTransfersApplication.getStockTransfersById(id);
       // sapRetirement.setAttbizId(id);
        return forward("sapStockTransfersDetail",sapStockTransfers);
    }

    /**
     * 删除存货转移单
     */
    public String deleteSapStockTransfers() {
        List<String> ids = this.getSDO().getIds();
        sapStockTransfersApplication.deleteByIds(ids);
        return success();
    }

}
