package com.huigou.topsun.sap.suppliers.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import com.huigou.topsun.common.AbstractPortalOrg;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * 供应商主数据导入
  */
@Table(name="tmp_suppliers_data")
@Data
@Entity
public class TmpSuppliersData extends AbstractPortalOrg {

    /**
     * 屏幕用途的bp角色
     */
    @Column(name = "rltgr")
    private String rltgr;

    /**
     * 业务伙伴分组
     */
    @Column(name = "bu_group")
    private String buGroup;

    /**
     * 业务伙伴编号
     */
    @Column(name = "partner")
    private String partner;

    /**
     * 称谓代码
     */
    @Column(name = "title")
    private String title;

    /**
     * 组织名称 1
     */
    @Column(name = "name_org1")
    private String nameOrg1;

    /**
     * 组织名称 2
     */
    @Column(name = "name_org2")
    private String nameOrg2;

    /**
     * 组织名称 3
     */
    @Column(name = "name_org3")
    private String nameOrg3;


    /**
     * 组织名称 4
     */
    @Column(name = "name_org4")
    private String nameOrg4;

    /**
     * 业务伙伴的搜索词1
     */
    @Column(name = "bu_sort1")
    private String buSort1;

    /**
     * 业务伙伴的搜索词2
     */
    @Column(name = "bu_sort2")
    private String buSort2;


    /**
     * 街道
     */
    @Column(name = "street")
    private String street;

    /**
     * 街道2
     */
    @Column(name = "str_suppl1")
    private String strSuppl1;

    /**
     * 街道3
     */
    @Column(name = "str_suppl2")
    private String strSuppl2;

    /**
     * 街道4
     */
    @Column(name = "str_suppl3")
    private String strSuppl3;


    /**
     * 街道5
     */
    @Column(name = "str_suppl4")
    private String strSuppl4;

    /**
     * 国家/地区代码
     */
    @Column(name = "land1")
    private String land1;

    /**
     * 国家/地区代码
     */
    @Column(name = "land1_name")
    private String land1Name;

    /**
     * 地区代码
     */
    @Column(name = "region")
    private String region;

    /**
     * 地区代码
     */
    @Column(name = "region_name")
    private String regionName;

    /**
     * 语言关键字
     */
    @Column(name = "langu")
    private String langu;

    /**
     * 城市
     */
    @Column(name = "city1")
    private String city1;

    /**
     * 城市
     */
    @Column(name = "city1_name")
    private String city1Name;

    /**
     * 城市邮政编码
     */
    @Column(name = "post_code1")
    private String postCode1;

    /**
     * 第一个电话号码
     */
    @Column(name = "tel_number")
    private String telNumber;

    /**
     * 一个电话号码:分机号
     */
    @Column(name = "tel_extens")
    private String telExtens;

    /**
     * 第一个移动电话号码
     */
    @Column(name = "mob_number")
    private String mobNumber;

    /**
     * 第一个移动电话号码:分机
     */
    @Column(name = "mob_extens")
    private String mobExtens;

    /**
     * 第一个传真号
     */
    @Column(name = "fax_number")
    private String faxNumber;

    /**
     * 第一个传真号：分机号
     */
    @Column(name = "fax_extens")
    private String faxExtens;

    /**
     * 电子邮件地址
     */
    @Column(name = "smtp_addr")
    private String smtpAddr;

    /**
     * 供应商帐户组
     */
    @Column(name = "ktokk")
    private String ktokk;

    /**
     * 集中设置的采购冻结
     */
    @Column(name = "sperm")
    private String sperm;

    /**
     * 中心记帐冻结
     */
    @Column(name = "sperr")
    private String sperr;

    /**
     * 贸易合作伙伴的公司标识
     */
    @Column(name = "vbund")
    private String vbund;

    /**
     * 客户编号
     */
    @Column(name = "kunnr")
    private String kunnr;

    /**
     * 责任税务部门的税收编号
     */
    @Column(name = "stenr")
    private String stenr;

    /**
     * 更新标识 I、U、D
     */
    @Column(name = "updkz")
    private String updkz;

     //申请类型  -1 删除  0 申请  1 修改
    @Column(name = "apply_type")
    private String applyType;

    /**
     * 银行所属国家/地区代码
     */
    @Column(name = "banks")
    private String banks;

    /**
     * 银行代码
     */
    @Column(name = "bankl")
    private String bankl;

    /**
     * 银行帐户号码
     */
    @Column(name = "bankn")
    private String bankn;

    /**
     * 账户持有人姓名
     */
    @Column(name = "koinh")
    private String koinh;

    /**
     * 银行控制代码
     */
    @Column(name = "bkont")
    private String bkont;

    /**
     * 对方开户行类型
     */
    @Column(name = "bvtyp")
    private String bvtyp;

    /**
     * 财务机构名称
     */
    @Column(name = "banka")
    private String banka;

    /**
     * 分行
     */
    @Column(name = "brnch")
    private String brnch;

    /**
     * 银行细目的参考明细
     */
    @Column(name = "bkref")
    private String bkref;

    /**
     * 联系人信息
     */
    @Column(name = "contact")
    private String contact;

    @Column(name = "contact1")
    private String contact1;

    @Column(name = "contact2")
    private String contact2;

    @Column(name = "contact3")
    private String contact3;

    @Column(name = "tel_number1")
    private String telNumber1;

    @Column(name = "tel_number2")
    private String telNumber2;

    @Column(name = "tel_number3")
    private String telNumber3;

    @Column(name = "fax_number1")
    private String faxNumber1;

    @Column(name = "fax_number2")
    private String faxNumber2;

    @Column(name = "fax_number3")
    private String faxNumber3;

    /**
     * 电子邮件地址
     */
    @Column(name = "smtp_addr1")
    private String smtpAddr1;

    /**
     * 电子邮件地址
     */
    @Column(name = "smtp_addr2")
    private String smtpAddr2;

    /**
     * 电子邮件地址
     */
    @Column(name = "smtp_addr3")
    private String smtpAddr3;

    //供应商公司信息

    /**
     * 公司代码
     */
    @Column(name = "bukrs")
    private String bukrs;

    /**
     * 总帐中的统驭科目
     */
    @Column(name = "akont")
    private String akont;


    /**
     * 根据分配号排序代码
     */
    @Column(name = "zuawa")
    private String zuawa;

    /**
     * 付款条件代码
     */
    @Column(name = "zterm")
    private String zterm;

    /**
     * 考虑的付款方式清单
     */
    @Column(name = "zwels")
    private String zwels;


    /**
     * 检查双重发票或信贷凭单的标志
     */
    @Column(name = "reprf")
    private String reprf;

    /**
     * 对公司代码过帐冻结
     */
    @Column(name = "sperr_b")
    private String sperrB;

    @Column(name = "sequence")
    private int sequence;

    //供应商采购组织信息
    /**
     * 采购组织
     */
    @Column(name = "ekorg")
    private String ekorg;

    /**
     * 货币码
     */
    @Column(name = "waers")
    private String waers;

    /**
     * 付款条件代码
     */
    @Column(name = "pay_condition")
    private String payCondition;

    /**
     * 国际贸易条款
     */
    @Column(name = "inco1")
    private String inco1;

    /**
     * 国际贸易条款位置 1
     */
    @Column(name = "inco2_l")
    private String inco2L;

    /**
     * 国际贸易条款位置 2
     */
    @Column(name = "inco3_l")
    private String inco3L;

    /**
     * 标识：基于收货的发票验证
     */
    @Column(name = "webre")
    private String webre;

    /**
     * 计算方案组（供应商）
     */
    @Column(name = "kalsk")
    private String kalsk;


    /**
     * 供应商办公室的负责销售人员
     */
    @Column(name = "verkf")
    private String verkf;


    /**
     * 供应商电话号码
     */
    @Column(name = "telf1")
    private String telf1;

    /**
     * 基于服务的发票校验标识
     */
    @Column(name = "lebre")
    private String lebre;

    /**
     * 边境运输方式（欧盟内部贸易统计）
     */
    @Column(name = "expvz")
    private String expvz;


}