package com.huigou.topsun.sap.suppliers.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.*;

/**
 * 供应商主数据
  */
@Table(name="sap_suppliers_info")
@Data
@Entity
public class SuppliersInfo extends FlowBillAbstractEntity {

    /**
     * 屏幕用途的bp角色
     */
    @Column(name = "rltgr")
    @JsonProperty("RLTGR")
    private String rltgr;

    /**
     * 业务伙伴分组
     */
    @Column(name = "bu_group")
    @JsonProperty("BU_GROUP")
    private String buGroup;

    /**
     * 业务伙伴编号
     */
    @Column(name = "partner")
    @JsonProperty("PARTNER")
    private String partner;

    /**
     * 称谓代码
     */
    @Column(name = "title")
    @JsonProperty("TITLE")
    private String title;

    /**
     * 组织名称 1
     */
    @Column(name = "name_org1")
    @JsonProperty("NAME_ORG1")
    private String nameOrg1;

    /**
     * 组织名称 2
     */
    @Column(name = "name_org2")
    @JsonProperty("NAME_ORG2")
    private String nameOrg2;

    /**
     * 组织名称 3
     */
    @Column(name = "name_org3")
    @JsonProperty("NAME_ORG3")
    private String nameOrg3;


    /**
     * 组织名称 4
     */
    @Column(name = "name_org4")
    @JsonProperty("NAME_ORG4")
    private String nameOrg4;

    /**
     * 业务伙伴的搜索词1
     */
    @Column(name = "bu_sort1")
    @JsonProperty("BU_SORT1")
    private String buSort1;

    /**
     * 业务伙伴的搜索词2
     */
    @Column(name = "bu_sort2")
    @JsonProperty("BU_SORT2")
    private String buSort2;


    /**
     * 街道
     */
    @Column(name = "street")
    @JsonProperty("STREET")
    private String street;

    /**
     * 街道2
     */
    @Column(name = "str_suppl1")
    @JsonProperty("STR_SUPPL1")
    private String strSuppl1;

    /**
     * 街道3
     */
    @Column(name = "str_suppl2")
    @JsonProperty("STR_SUPPL2")
    private String strSuppl2;

    /**
     * 街道4
     */
    @Column(name = "str_suppl3")
    @JsonProperty("STR_SUPPL3")
    private String strSuppl3;


    /**
     * 街道5
     */
    @Column(name = "str_suppl4")
    @JsonProperty("STR_SUPPL4")
    private String strSuppl4;

    /**
     * 国家/地区代码
     */
    @Column(name = "land1")
    @JsonProperty("LAND1")
    private String land1;

    /**
     * 国家/地区代码
     */
    @Column(name = "land1_name")
    private String land1Name;

    /**
     * 地区代码
     */
    @Column(name = "region")
    @JsonProperty("REGION")
    private String region;

    /**
     * 地区代码
     */
    @Column(name = "region_name")
    private String regionName;

    /**
     * 语言关键字
     */
    @Column(name = "langu")
    @JsonProperty("LANGU")
    private String langu;

    /**
     * 城市
     */
    @Column(name = "city1")
    @JsonProperty("CITY1")
    private String city1;

    /**
     * 城市
     */
    @Column(name = "city1_name")
    private String city1Name;

    /**
     * 城市邮政编码
     */
    @Column(name = "post_code1")
    @JsonProperty("POST_CODE1")
    private String postCode1;

    /**
     * 第一个电话号码
     */
    @Column(name = "tel_number")
    @JsonProperty("TEL_NUMBER")
    private String telNumber;

    /**
     * 一个电话号码:分机号
     */
    @Column(name = "tel_extens")
    @JsonProperty("TEL_EXTENS")
    private String telExtens;

    /**
     * 第一个移动电话号码
     */
    @Column(name = "mob_number")
    @JsonProperty("MOB_NUMBER")
    private String mobNumber;

    /**
     * 第一个移动电话号码:分机
     */
    @Column(name = "mob_extens")
    @JsonProperty("MOB_EXTENS")
    private String mobExtens;

    /**
     * 第一个传真号
     */
    @Column(name = "fax_number")
    @JsonProperty("FAX_NUMBER")
    private String faxNumber;

    /**
     * 第一个传真号：分机号
     */
    @Column(name = "fax_extens")
    @JsonProperty("FAX_EXTENS")
    private String faxExtens;

    /**
     * 电子邮件地址
     */
    @Column(name = "smtp_addr")
    @JsonProperty("SMTP_ADDR")
    private String smtpAddr;

    /**
     * 供应商帐户组
     */
    @Column(name = "ktokk")
    @JsonProperty("KTOKK")
    private String ktokk;

    /**
     * 集中设置的采购冻结
     */
    @Column(name = "sperm")
    @JsonProperty("SPERM")
    private String sperm;

    /**
     * 中心记帐冻结
     */
    @Column(name = "sperr")
    @JsonProperty("SPERR")
    private String sperr;

    /**
     * 贸易合作伙伴的公司标识
     */
    @Column(name = "vbund")
    @JsonProperty("VBUND")
    private String vbund;

    /**
     * 客户编号
     */
    @Column(name = "kunnr")
    @JsonProperty("KUNNR")
    private String kunnr;

    /**
     * 责任税务部门的税收编号
     */
    @Column(name = "stenr")
    @JsonProperty("STENR")
    private String stenr;

    /**
     * 更新标识 I、U、D
     */
    @Column(name = "updkz")
    @JsonProperty("UPDKZ")
    private String updkz;

     //申请类型  -1 删除  0 申请  1 修改
    @Column(name = "apply_type")
    private String applyType;

    /**
     * 银行所属国家/地区代码
     */
    @Column(name = "banks")
    @JSONField(name = "BANKS")
    private String banks;

    /**
     * 银行代码
     */
    @Column(name = "bankl")
    @JSONField(name = "BANKL")
    private String bankl;

    /**
     * 银行帐户号码
     */
    @Column(name = "bankn")
    @JSONField(name = "BANKN")
    private String bankn;

    /**
     * 账户持有人姓名
     */
    @Column(name = "koinh")
    @JSONField(name = "KOINH")
    private String koinh;

    /**
     * 银行控制代码
     */
    @Column(name = "bkont")
    @JSONField(name = "BKONT")
    private String bkont;

    /**
     * 对方开户行类型
     */
    @Column(name = "bvtyp")
    @JSONField(name = "BVTYP")
    private String bvtyp;

    /**
     * 财务机构名称
     */
    @Column(name = "banka")
    @JSONField(name = "BANKA")
    private String banka;

    /**
     * 分行
     */
    @Column(name = "brnch")
    @JSONField(name = "BRNCH")
    private String brnch;

    /**
     * 银行细目的参考明细
     */
    @Column(name = "bkref")
    @JSONField(name = "BKREF")
    private String bkref;

//    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
//    @Column(name = "fillin_date")
//    @Temporal(TemporalType.TIMESTAMP)
//    private Date fillinDate;

    @Transient
    private String sId;

    @Column(name = "contact")
    private String contact;

    @Column(name = "contact1")
    private String contact1;

    @Column(name = "contact2")
    private String contact2;

    @Column(name = "contact3")
    private String contact3;

    @Column(name = "tel_number1")
    private String telNumber1;

    @Column(name = "tel_number2")
    private String telNumber2;

    @Column(name = "tel_number3")
    private String telNumber3;

    @Column(name = "fax_number1")
    private String faxNumber1;

    @Column(name = "fax_number2")
    private String faxNumber2;

    @Column(name = "fax_number3")
    private String faxNumber3;

    /**
     * 电子邮件地址
     */
    @Column(name = "smtp_addr1")
    private String smtpAddr1;

    /**
     * 电子邮件地址
     */
    @Column(name = "smtp_addr2")
    private String smtpAddr2;

    /**
     * 电子邮件地址
     */
    @Column(name = "smtp_addr3")
    private String smtpAddr3;


    @Override
    protected String getCodeRuleId() {
        return "sapSuppliersInfo";
    }

//    @Transient
//   private List<SuppliersPay>  suppliersPayList;
//
//    @Transient
//    private List<SuppliersBuyer>  suppliersBuyerList;
//
//   @Transient
//    private List<SuppliersBank>  suppliersBankList;
}