package com.huigou.topsun.sap.suppliers.application.impl;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.suppliers.domain.SuppliersBuyer;
import com.huigou.topsun.sap.suppliers.domain.SuppliersInfo;
import com.huigou.topsun.sap.suppliers.domain.SuppliersPay;
import com.huigou.topsun.sap.suppliers.domain.TmpSuppliersData;
import com.huigou.topsun.sap.suppliers.repository.SuppliersBuyerRepository;
import com.huigou.topsun.sap.suppliers.repository.SuppliersInfoRepository;
import com.huigou.topsun.sap.suppliers.repository.SuppliersPayRepository;
import com.huigou.topsun.sap.suppliers.repository.TmpSuppliersDataRepository;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.uasp.tool.dataimport.application.ExcelImportInterface;
import com.huigou.util.ClassHelper;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service("suppliersDataExcelImport")
public class SuppliersDataExcelImport extends CommonController implements ExcelImportInterface {

    @Autowired
    private TmpSuppliersDataRepository tmpSuppliersDataRepository;
    @Autowired
    private SuppliersInfoRepository suppliersInfoRepository;
    @Autowired
    private SuppliersBuyerRepository suppliersBuyerRepository;
    @Autowired
    private SuppliersPayRepository suppliersPayRepository;
    @Override
    public void executeImport(String batchNumber) {
        List<TmpSuppliersData> tmpSuppliersDataList = tmpSuppliersDataRepository.findByBatchNumber(batchNumber);
        Operator operator = this.getOperator();
        OrgUnit orgUnit = new OrgUnit(operator.getFullId(), operator.getFullName());
        if (!CollectionUtils.isEmpty(tmpSuppliersDataList)){
            for (TmpSuppliersData tmpSuppliersData : tmpSuppliersDataList) {
                SuppliersInfo suppliersInfo = new SuppliersInfo();
                ClassHelper.copyProperties(tmpSuppliersData,suppliersInfo);
                suppliersInfo.setId(null);
                suppliersInfo.setRltgr("Z00001X");
                suppliersInfo.setStatusId(BizBillStatus.COMPLETED.getId());
                suppliersInfo.setApplyType("0");
                suppliersInfo.setSperr("0");
                suppliersInfo.setSperm("0");
                suppliersInfo.setDefaultValues(orgUnit);
                suppliersInfoRepository.save(suppliersInfo);

                //供应商采购组织信息
                SuppliersBuyer suppliersBuyer = new SuppliersBuyer();
                ClassHelper.copyProperties(tmpSuppliersData,suppliersBuyer);
                suppliersBuyer.setSId(suppliersInfo.getId());
                suppliersBuyer.setWebre("X");//检查双重发票
                suppliersBuyer.setKalsk("Z1");//供应商方案组
                suppliersBuyerRepository.save(suppliersBuyer);

                //供应商公司信息
                SuppliersPay suppliersPay = new SuppliersPay();
                ClassHelper.copyProperties(tmpSuppliersData,suppliersPay);
                suppliersPay.setSId(suppliersInfo.getId());
                suppliersPay.setReprf("X");//检查双重发票
                suppliersPayRepository.save(suppliersPay);
            }
        }
        System.out.println("批次数据导入完成：" + batchNumber);
    }

}
