package com.huigou.topsun.sap.statsIndicators.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 
 * @TableName sap_stats_indicators_result
 */
@Table(name="sap_stats_indicators_result")
@Entity
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class SapStatsIndicatorsResult implements Serializable {
    /**
     * 回执信息id
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "stats_indicators_result_id")
    private String statsIndicatorsResultId;

    /**
     * 主表id
     */
    @Column(name = "stats_indicators_id")
    private String statsIndicatorsId;

    /**
     * 消息类型
     */
    @Column(name = "TYPE")
    private String TYPE;

    /**
     * 消息类
     */
    @Column(name = "ID")
    private String ID;

    /**
     * 消息编号
     */
    @Column(name = "NUMBER")
    private Integer NUMBER;

    /**
     * 消息文本
     */
    @Column(name = "MESSAGE")
    private String MESSAGE;

    /**
     * 应用程序日志：日志编号
     */
    @Column(name = "LOG_NO")
    private String LOG_NO;

    /**
     * 应用程序日志：内部消息序列号
     */
    @Column(name = "LOG_MSG_NO")
    private Integer LOG_MSG_NO;

    /**
     * 消息变量
     */
    @Column(name = "MESSAGE_V1")
    private String MESSAGE_V1;

    /**
     * 消息变量
     */
    @Column(name = "MESSAGE_V2")
    private String MESSAGE_V2;

    /**
     * 消息变量
     */
    @Column(name = "MESSAGE_V3")
    private String MESSAGE_V3;

    /**
     * 消息变量
     */
    @Column(name = "MESSAGE_V4")
    private String MESSAGE_V4;

    /**
     * 参数名称
     */
    @Column(name = "PARAMETER")
    private String PARAMETER;

    /**
     * 参数中的行
     */
    @Column(name = "`ROW`")
    private Integer ROW;

    /**
     * 参数中的字段
     */
    @Column(name = "FIELD")
    private String FIELD;

    /**
     * 引发消息的逻辑系统
     */
    @Column(name = "`SYSTEM`")
    private String SYSTEM;

    /**
     * 凭证编号
     */
    @Column(name = "BELNR")
    private String BELNR;

    private static final long serialVersionUID = 1L;
}