package com.huigou.topsun.sap.statsIndicators.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 
 * @TableName sap_stats_indicators
 */
@Table(name="sap_stats_indicators")
@Entity
@Data
public class SapStatsIndicators extends FlowBillAbstractEntity {
    /**
     * 成本控制范围
     */
    @Column(name = "KOKRS")
    private String kokrs;

    /**
     * 凭证日期
     */
    @Column(name = "BLDAT")
    private Date bldat;

    /**
     * 过账日期
     */
    @Column(name = "BUDAT")
    private Date budat;

    /**
     * 凭证文本
     */
    @Column(name = "BLTXT")
    private String bltxt;

    /**
     * SAP用户名
     */
    @Column(name = "USNAM")
    private String usnam;


    @Override
    protected String getCodeRuleId() {
        return "sapStatsIndicators";
    }
}