package com.huigou.topsun.sap.statsIndicators.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.sap.statsIndicators.application.SapStatsIndicatorsDetailApplication;
import com.huigou.topsun.sap.statsIndicators.domain.query.SapStatsIndicatorsDetailQueryRequest;
import com.huigou.topsun.sap.statsIndicators.repository.SapStatsIndicatorsDetailRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class SapStatsIndicatorsDetailApplicationImpl extends BaseApplication implements SapStatsIndicatorsDetailApplication {
    @Autowired
    private SapStatsIndicatorsDetailRepository sapStatsIndicatorsDetailRepository;

    @Override
    public Map<String, Object> slicedStatsIndicatorsDetailQuery(SapStatsIndicatorsDetailQueryRequest query) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedStatsIndicatorsDetailQuery");
        return this.sqlExecutorDao.executeSlicedQuery(queryDescriptor,query);
    }

    @Override
    public void deleteStatsIndicatorsDetail(List<String> ids) {
        ids.forEach(id->{
            sapStatsIndicatorsDetailRepository.delete(id);
        });
    }
}
